/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.starfruit.ratatouillefrieddelights.RatatouilleFriedDelights;
import org.starfruit.ratatouillefrieddelights.data.RFDGlobalLootModifierProvider;
import org.starfruit.ratatouillefrieddelights.data.RFDRegistrateTags;
import org.starfruit.ratatouillefrieddelights.data.recipe.RFDRecipeProvider;
import org.starfruit.ratatouillefrieddelights.data.recipe.RFDStandardRecipeGen;
import org.starfruit.ratatouillefrieddelights.data.recipe.create.RFDSequencedAssemblyRecipeGen;
import org.starfruit.ratatouillefrieddelights.entry.RFDPonderPlugin;
import org.starfruit.ratatouillefrieddelights.worldgen.RFDBiomeModifiers;
import org.starfruit.ratatouillefrieddelights.worldgen.RFDConfiguredFeatures;
import org.starfruit.ratatouillefrieddelights.worldgen.RFDPlacedFeatures;

public class RFDDataGen {
    public static void gatherDataHighPriority(GatherDataEvent event) {
        if (event.getMods().contains("ratatouille_fried_delights")) {
            RFDDataGen.addExtraRegistrateData();
        }
    }

    private static void addExtraRegistrateData() {
        RFDRegistrateTags.addGenerators();
        RatatouilleFriedDelights.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            RFDDataGen.provideDefaultLang("en_us", langConsumer);
            RFDDataGen.providePonderLang(langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/ratatouille_fried_delights/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new RFDPonderPlugin());
        PonderIndex.getLangAccess().provideLang("ratatouille_fried_delights", consumer);
    }

    public static void gatherData(GatherDataEvent event) {
        if (!event.getMods().contains("ratatouille_fried_delights")) {
            return;
        }
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        RegistrySetBuilder worldgenBuilder = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, RFDConfiguredFeatures::bootstrap).add(Registries.PLACED_FEATURE, RFDPlacedFeatures::bootstrap).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, RFDBiomeModifiers::bootstrap);
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, worldgenBuilder, Set.of("ratatouille_fried_delights")));
        generator.addProvider(event.includeServer(), (DataProvider)new RFDStandardRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RFDSequencedAssemblyRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RFDGlobalLootModifierProvider(output, lookupProvider));
        if (event.includeServer()) {
            RFDRecipeProvider.registerAllProcessing(generator, output, lookupProvider);
        }
    }
}

