/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.food;

import com.mojang.serialization.MapCodec;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.starfruit.ratatouillefrieddelights.entry.RFDItems;

@MethodsReturnNonnullByDefault
public class BoxedFriesBlock
extends HorizontalDirectionalBlock {
    public static final Property<Integer> REMAINING_BITES = IntegerProperty.create((String)"remaining_bites", (int)0, (int)3);
    public static final MapCodec<BoxedFriesBlock> CODEC = BoxedFriesBlock.simpleCodec(BoxedFriesBlock::new);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0), Block.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)10.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0), Block.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)10.0, (double)11.0)};
    private static final VoxelShape[] SHELLS = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)6.0, (double)10.0), Block.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)6.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)6.0, (double)10.0), Block.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)6.0, (double)11.0)};

    public BoxedFriesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(REMAINING_BITES, (Comparable)Integer.valueOf(3))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return (Integer)state.getValue(REMAINING_BITES) == 0 ? SHELLS[((Direction)state.getValue((Property)FACING)).get2DDataValue()] : SHAPES[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{REMAINING_BITES}).add(new Property[]{FACING});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue(REMAINING_BITES);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        int bites = (Integer)state.getValue(REMAINING_BITES);
        if (bites == 0) {
            level.destroyBlock(pos, true, (Entity)player);
        } else {
            ItemStack fry = new ItemStack((ItemLike)RFDItems.A_FRY.get());
            if (!player.addItem(fry)) {
                player.drop(fry, false);
            }
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.6f, 1.0f);
            level.setBlock(pos, (BlockState)state.setValue(REMAINING_BITES, (Comparable)Integer.valueOf(bites - 1)), 3);
        }
        return InteractionResult.SUCCESS;
    }
}

