/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.drumprocessor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.starfruit.ratatouillefrieddelights.content.drumprocessor.DrumProcessorBlock;
import org.starfruit.ratatouillefrieddelights.content.drumprocessor.DrumProcessorBlockEntity;
import org.starfruit.ratatouillefrieddelights.entry.RFDPartialModels;

public class DrumProcessorRenderer
extends KineticBlockEntityRenderer<DrumProcessorBlockEntity> {
    public DrumProcessorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(DrumProcessorBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
    }

    protected SuperByteBuffer getRotatedModel(DrumProcessorBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacingVertical((PartialModel)RFDPartialModels.DRUM, (BlockState)state, (Direction)((Direction)state.getValue(DrumProcessorBlock.HORIZONTAL_FACING)));
    }

    protected void renderItems(DrumProcessorBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (be.getLevel() == null) {
            return;
        }
        ItemStack item1 = be.inputInv.getStackInSlot(0);
        ItemStack item2 = be.inputInv.getStackInSlot(1);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        float angleRad = DrumProcessorRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)be.getBlockPos(), (Direction.Axis)DrumProcessorRenderer.getRotationAxisOf((KineticBlockEntity)be));
        float angleDeg = angleRad * 57.295776f;
        float scale = 0.4f;
        float xOffset = 0.0f;
        float zOffset = 0.0f;
        Direction dir = be.getEjectDirection();
        switch (dir) {
            case NORTH: {
                zOffset = -0.0625f;
                break;
            }
            case SOUTH: {
                zOffset = 0.0625f;
                break;
            }
            case WEST: {
                xOffset = -0.0625f;
                break;
            }
            case EAST: {
                xOffset = 0.0625f;
            }
        }
        Axis axis = switch (dir.getAxis()) {
            case Direction.Axis.X -> Axis.XP;
            case Direction.Axis.Z -> Axis.ZP;
            default -> Axis.YP;
        };
        if (!item1.isEmpty()) {
            ms.pushPose();
            ms.translate(0.5, 0.5, 0.5);
            ms.mulPose(axis.rotationDegrees(angleDeg));
            ms.translate((double)xOffset, 0.2, (double)zOffset);
            ms.scale(scale, scale, scale);
            if (!(item1.getItem() instanceof BlockItem)) {
                ms.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            itemRenderer.renderStatic(item1, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.getLevel(), 0);
            ms.popPose();
        }
        if (!item2.isEmpty()) {
            ms.pushPose();
            ms.translate(0.5, 0.5, 0.5);
            ms.mulPose(axis.rotationDegrees(angleDeg));
            ms.translate((double)xOffset, -0.2, (double)zOffset);
            ms.scale(scale, scale, scale);
            if (!(item2.getItem() instanceof BlockItem)) {
                ms.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            itemRenderer.renderStatic(item2, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.getLevel(), 0);
            ms.popPose();
        }
    }
}

