/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.drumprocessor;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.starfruit.ratatouillefrieddelights.content.drumprocessor.DrumProcessorBlockEntity;
import org.starfruit.ratatouillefrieddelights.entry.RFDBlockEntityTypes;

public class DrumProcessorBlock
extends HorizontalKineticBlock
implements IBE<DrumProcessorBlockEntity> {
    public DrumProcessorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferredFacing = this.getPreferredHorizontalFacing(context);
        if (preferredFacing == null) {
            preferredFacing = context.getHorizontalDirection();
        }
        preferredFacing = preferredFacing.getClockWise();
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)(context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? preferredFacing : preferredFacing.getOpposite()));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, millstone -> {
            int slot;
            boolean emptyOutput = true;
            ItemStackHandler inv = millstone.outputInv;
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (!stackInSlot.isEmpty()) {
                    emptyOutput = false;
                }
                player.getInventory().placeItemBackInInventory(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.EMPTY);
            }
            if (emptyOutput) {
                inv = millstone.inputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    player.getInventory().placeItemBackInInventory(inv.getStackInSlot(slot));
                    inv.setStackInSlot(slot, ItemStack.EMPTY);
                }
            }
            millstone.setChanged();
            millstone.sendData();
        });
        return ItemInteractionResult.SUCCESS;
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityAfterFallOn(worldIn, entityIn);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getClockWise() == face;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getClockWise().getAxis();
    }

    public Class<DrumProcessorBlockEntity> getBlockEntityClass() {
        return DrumProcessorBlockEntity.class;
    }

    public BlockEntityType<? extends DrumProcessorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)RFDBlockEntityTypes.DRUM_PROCESSOR.get();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        boolean isZ = ((Direction)pState.getValue(HORIZONTAL_FACING)).getAxis() == Direction.Axis.Z;
        return Shapes.or((VoxelShape)Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), (VoxelShape)Shapes.create((double)(isZ ? 0.0 : 0.0625), (double)0.125, (double)(isZ ? 0.0625 : 0.0), (double)(isZ ? 1.0 : 0.9375), (double)0.9375, (double)(isZ ? 0.9375 : 1.0)));
    }
}

