/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.dipcup;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.starfruit.ratatouillefrieddelights.content.dipcup.DipCupBlock;
import org.starfruit.ratatouillefrieddelights.entry.RFDDataComponents;

public class DipableItem
extends Item {
    public DipableItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        Block block = state.getBlock();
        if (block instanceof DipCupBlock) {
            DipCupBlock dipCup = (DipCupBlock)block;
            if (((Boolean)state.getValue(DipCupBlock.OPENED)).booleanValue()) {
                int newColor;
                int remaining = (Integer)state.getValue(DipCupBlock.REMAINING_DIP);
                if (remaining == 0) {
                    return InteractionResult.FAIL;
                }
                ItemStack dipped = stack.copy();
                dipped.setCount(1);
                int finalColor = newColor = dipCup.dipColor;
                if (dipped.has(RFDDataComponents.DIP_COLOR)) {
                    int oldColor = (Integer)dipped.getOrDefault(RFDDataComponents.DIP_COLOR, (Object)-1);
                    finalColor = DipableItem.mixColorRGBA(oldColor, newColor);
                }
                dipped.set(RFDDataComponents.DIP_COLOR, (Object)finalColor);
                stack.shrink(1);
                if (context.getPlayer() != null && !context.getPlayer().addItem(dipped)) {
                    context.getPlayer().drop(dipped, false);
                }
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(DipCupBlock.REMAINING_DIP, (Comparable)Integer.valueOf(remaining - 1)));
                level.playSound(null, pos, SoundEvents.HONEY_DRINK, SoundSource.BLOCKS, 0.5f + level.random.nextFloat() * 0.3f, 0.9f + level.random.nextFloat() * 0.2f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    private static int mixColorRGBA(int c1, int c2) {
        int a1 = c1 >> 24 & 0xFF;
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int a2 = c2 >> 24 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int a = (a1 + a2) / 2;
        int r = (r1 + r2) / 2;
        int g = (g1 + g2) / 2;
        int b = (b1 + b2) / 2;
        return a << 24 | r << 16 | g << 8 | b;
    }
}

