/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.dipcup;

import com.mojang.serialization.MapCodec;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.starfruit.ratatouillefrieddelights.entry.RFDSpriteShifts;

public class DipCupBlock
extends HorizontalDirectionalBlock {
    public static final Property<Integer> REMAINING_DIP = IntegerProperty.create((String)"remaining_dip", (int)0, (int)3);
    public static final Property<Boolean> OPENED = BooleanProperty.create((String)"opened");
    public static final MapCodec<HorizontalDirectionalBlock> CODEC = DipCupBlock.simpleCodec(DipCupBlock::new);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)3.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)3.0, (double)10.0), Block.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)3.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)3.0, (double)10.0)};
    public final int dipColor;
    public final SpriteShiftEntry sealSprite;

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPES[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
    }

    public DipCupBlock(BlockBehaviour.Properties props) {
        this(props, 0xFFFFFF, RFDSpriteShifts.DIP_CUP_KETCHUP);
    }

    public static int rgbaToArgb(int rgba) {
        int r = rgba >> 24 & 0xFF;
        int g = rgba >> 16 & 0xFF;
        int b = rgba >> 8 & 0xFF;
        int a = rgba & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int rgbaToAbgr(int rgba) {
        int r = rgba >> 24 & 0xFF;
        int g = rgba >> 16 & 0xFF;
        int b = rgba >> 8 & 0xFF;
        int a = rgba & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }

    public DipCupBlock(BlockBehaviour.Properties props, int dipColor, SpriteShiftEntry sealSprite) {
        super(props);
        this.dipColor = dipColor;
        this.sealSprite = sealSprite;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(REMAINING_DIP, (Comparable)Integer.valueOf(3))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(OPENED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue(REMAINING_DIP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{REMAINING_DIP}).add(new Property[]{OPENED}).add(new Property[]{FACING});
        super.createBlockStateDefinition(builder);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        boolean opened = (Boolean)state.getValue(OPENED);
        if (opened && (Integer)state.getValue(REMAINING_DIP) == 0) {
            level.destroyBlock(pos, true);
            return InteractionResult.SUCCESS;
        }
        if (opened) {
            return InteractionResult.PASS;
        }
        level.setBlock(pos, (BlockState)state.setValue(OPENED, (Comparable)Boolean.valueOf(true)), 3);
        level.playSound(null, pos, SoundEvents.WOODEN_TRAPDOOR_OPEN, SoundSource.BLOCKS, 0.6f, 1.0f);
        return InteractionResult.SUCCESS;
    }
}

