/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.dipcup;

import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.starfruit.ratatouillefrieddelights.content.dipcup.DipCupBlock;
import org.starfruit.ratatouillefrieddelights.entry.RFDSpriteShifts;

public class DipCupBakedModel
extends BakedModelWrapperWithData {
    public DipCupBakedModel(BakedModel originalModel) {
        super(originalModel);
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        boolean opened = (Boolean)state.getValue(DipCupBlock.OPENED);
        int remaining = (Integer)state.getValue(DipCupBlock.REMAINING_DIP);
        builder.with(DipCupModelData.OPENED, (Object)opened);
        builder.with(DipCupModelData.SEAL_SPRITE, (Object)((DipCupBlock)state.getBlock()).sealSprite);
        builder.with(DipCupModelData.REMAINING_DIP, (Object)remaining);
        return builder;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        int remaining;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, data, renderType));
        if (state == null || side != null) {
            return quads;
        }
        boolean opened = Boolean.TRUE.equals(data.get(DipCupModelData.OPENED));
        SpriteShiftEntry seal = (SpriteShiftEntry)data.get(DipCupModelData.SEAL_SPRITE);
        int n = remaining = data.get(DipCupModelData.REMAINING_DIP) == null ? 0 : (Integer)data.get(DipCupModelData.REMAINING_DIP);
        if (!opened && seal != null) {
            quads.add(this.renderSeal(state, seal));
            return quads;
        }
        if (remaining > 0 && opened) {
            quads.add(this.renderDip(state, remaining));
        }
        return quads;
    }

    private BakedQuad renderSeal(BlockState state, SpriteShiftEntry seal) {
        Direction facing = state.hasProperty((Property)DipCupBlock.FACING) ? (Direction)state.getValue((Property)DipCupBlock.FACING) : Direction.NORTH;
        TextureAtlasSprite sprite = seal.getTarget();
        int[] vertexData = new int[BakedQuadHelper.VERTEX_STRIDE * 4];
        float y = 0.1885f;
        float x0 = 0.25f;
        float x1 = 0.75f;
        float z0 = 0.25f;
        float z1 = 0.75f;
        float[][] positions = new float[][]{{x0, z0}, {x0, z1}, {x1, z1}, {x1, z0}};
        for (int i = 0; i < 4; ++i) {
            float[] p = this.rotate(positions[i][0], positions[i][1], facing);
            float u = i == 0 || i == 1 ? sprite.getU0() : sprite.getU1();
            float v = i == 0 || i == 3 ? sprite.getV0() : sprite.getV1();
            this.setVertex(vertexData, i, p[0], y, p[1], u, v, -1);
        }
        return new BakedQuad(vertexData, -1, Direction.UP, sprite, true);
    }

    private BakedQuad renderDip(BlockState state, int remaining) {
        Direction facing = state.hasProperty((Property)DipCupBlock.FACING) ? (Direction)state.getValue((Property)DipCupBlock.FACING) : Direction.NORTH;
        int color = DipCupBlock.rgbaToAbgr(((DipCupBlock)state.getBlock()).dipColor);
        TextureAtlasSprite sprite = RFDSpriteShifts.DIP_CUP_SOURCE.getTarget();
        int[] vertexData = new int[BakedQuadHelper.VERTEX_STRIDE * 4];
        float baseY = 0.03125f;
        float height = switch (remaining) {
            case 3 -> 0.15625f;
            case 2 -> 0.10625f;
            case 1 -> 0.0625f;
            default -> 0.0f;
        };
        float y = baseY + height;
        float x0 = 0.28125f;
        float x1 = 0.71875f;
        float z0 = 0.26875f;
        float z1 = 0.73125f;
        float[][] positions = new float[][]{{x0, z0}, {x0, z1}, {x1, z1}, {x1, z0}};
        for (int i = 0; i < 4; ++i) {
            float[] p = this.rotate(positions[i][0], positions[i][1], facing);
            float u = i == 0 || i == 1 ? sprite.getU0() : sprite.getU1();
            float v = i == 0 || i == 3 ? sprite.getV0() : sprite.getV1();
            this.setVertex(vertexData, i, p[0], y, p[1], u, v, color);
        }
        return new BakedQuad(vertexData, -1, Direction.UP, sprite, true);
    }

    private float[] rotate(float x, float z, Direction facing) {
        float[] fArray;
        switch (facing) {
            case NORTH: {
                float[] fArray2 = new float[2];
                fArray2[0] = x;
                fArray = fArray2;
                fArray2[1] = z;
                break;
            }
            case SOUTH: {
                float[] fArray3 = new float[2];
                fArray3[0] = 1.0f - x;
                fArray = fArray3;
                fArray3[1] = 1.0f - z;
                break;
            }
            case WEST: {
                float[] fArray4 = new float[2];
                fArray4[0] = z;
                fArray = fArray4;
                fArray4[1] = 1.0f - x;
                break;
            }
            case EAST: {
                float[] fArray5 = new float[2];
                fArray5[0] = 1.0f - z;
                fArray = fArray5;
                fArray5[1] = x;
                break;
            }
            default: {
                float[] fArray6 = new float[2];
                fArray6[0] = x;
                fArray = fArray6;
                fArray6[1] = z;
            }
        }
        return fArray;
    }

    private void setVertex(int[] vertexData, int vertex, float x, float y, float z, float u, float v, int color) {
        int offset = vertex * BakedQuadHelper.VERTEX_STRIDE;
        vertexData[offset + 0] = Float.floatToRawIntBits(x);
        vertexData[offset + 1] = Float.floatToRawIntBits(y);
        vertexData[offset + 2] = Float.floatToRawIntBits(z);
        vertexData[offset + 3] = color;
        vertexData[offset + 4] = Float.floatToRawIntBits(u);
        vertexData[offset + 5] = Float.floatToRawIntBits(v);
        vertexData[offset + 6] = 0;
        vertexData[offset + 7] = 0x7F7F0000;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout()});
    }

    private static class DipCupModelData {
        private static final ModelProperty<Boolean> OPENED = new ModelProperty();
        private static final ModelProperty<SpriteShiftEntry> SEAL_SPRITE = new ModelProperty();
        private static final ModelProperty<Integer> REMAINING_DIP = new ModelProperty();

        private DipCupModelData() {
        }
    }
}

