/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.continuousfryer;

import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerInventory;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingItemStack;

public class ItemHandlerFryerSegment
implements IItemHandler {
    private final FryerInventory fryerInventory;
    int offset;

    public ItemHandlerFryerSegment(FryerInventory beltInventory, int offset) {
        this.fryerInventory = beltInventory;
        this.offset = offset;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        FryingItemStack stackAtOffset = this.fryerInventory.getStackAtOffset(this.offset);
        if (stackAtOffset == null) {
            return ItemStack.EMPTY;
        }
        return stackAtOffset.stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.fryerInventory.canInsertAt(this.offset)) {
            ItemStack remainder = ItemHelper.limitCountToMaxStackSize((ItemStack)stack, (boolean)simulate);
            if (!simulate) {
                FryingItemStack newStack = new FryingItemStack(stack);
                newStack.insertedAt = this.offset;
                newStack.prevFryerPosition = newStack.fryerPosition = (float)this.offset + 0.5f + (float)(this.fryerInventory.fryerMovementPositive ? -1 : 1) / 16.0f;
                this.fryerInventory.addItem(newStack);
                this.fryerInventory.fryer.setChanged();
                this.fryerInventory.fryer.sendData();
            }
            return remainder;
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extracted;
        FryingItemStack transported = this.fryerInventory.getStackAtOffset(this.offset);
        if (transported == null) {
            return ItemStack.EMPTY;
        }
        amount = Math.min(amount, transported.stack.getCount());
        ItemStack itemStack = extracted = simulate ? transported.stack.copy().split(amount) : transported.stack.split(amount);
        if (!simulate) {
            if (transported.stack.isEmpty()) {
                this.fryerInventory.toRemove.add(transported);
            } else {
                this.fryerInventory.fryer.notifyUpdate();
            }
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return Math.min((Integer)this.getStackInSlot(slot).getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64), 64);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }
}

