/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.continuousfryer;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.Arrays;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import org.starfruit.ratatouillefrieddelights.entry.RFDRecipeTypes;

public class FryingRecipe
extends StandardProcessingRecipe<RecipeInput> {
    public FryingRecipe(ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)RFDRecipeTypes.FRYING, params);
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(RecipeInput inv, @NotNull Level worldIn) {
        if (inv.isEmpty()) {
            return false;
        }
        return ((Ingredient)this.ingredients.getFirst()).test(inv.getItem(0));
    }

    public boolean matches(ItemStack item, FluidStack fluid, BlazeBurnerBlock.HeatLevel heatLevel) {
        if (this.fluidIngredients.isEmpty()) {
            return ((Ingredient)this.ingredients.getFirst()).test(item) && this.getRequiredHeat().testBlazeBurner(heatLevel);
        }
        SizedFluidIngredient fluidIngredient = (SizedFluidIngredient)this.fluidIngredients.getFirst();
        boolean sameFluid = Arrays.stream(fluidIngredient.getFluids()).anyMatch(fs -> fs.getFluid().getFluidType() == fluid.getFluid().getFluidType());
        return ((Ingredient)this.ingredients.getFirst()).test(item) && sameFluid && fluid.getAmount() >= ((SizedFluidIngredient)this.fluidIngredients.getFirst()).amount() && this.getRequiredHeat().testBlazeBurner(heatLevel);
    }
}

