/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.continuousfryer;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingItemStack;

public class FryingItemStackHandlerBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<FryingItemStackHandlerBehaviour> TYPE = new BehaviourType();
    private ProcessingCallback processingCallback;
    private PositionGetter positionGetter;

    public FryingItemStackHandlerBehaviour(SmartBlockEntity be, ProcessingCallback processingCallback) {
        super(be);
        this.processingCallback = processingCallback;
        this.positionGetter = t -> VecHelper.getCenterOf((Vec3i)be.getBlockPos());
    }

    public FryingItemStackHandlerBehaviour withStackPlacement(PositionGetter function) {
        this.positionGetter = function;
        return this;
    }

    public void handleProcessingOnAllItems(Function<FryingItemStack, FryingResult> processFunction) {
        this.handleCenteredProcessingOnAllItems(0.51f, processFunction);
    }

    public void handleProcessingOnItem(FryingItemStack item, FryingResult processOutput) {
        this.handleCenteredProcessingOnAllItems(0.51f, t -> {
            if (t == item) {
                return processOutput;
            }
            return null;
        });
    }

    public void handleCenteredProcessingOnAllItems(float maxDistanceFromCenter, Function<FryingItemStack, FryingResult> processFunction) {
        this.processingCallback.applyToAllItems(maxDistanceFromCenter, processFunction);
    }

    public Vec3 getWorldPositionOf(FryingItemStack transported) {
        return this.positionGetter.getWorldPositionVector(transported);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    @FunctionalInterface
    public static interface ProcessingCallback {
        public void applyToAllItems(float var1, Function<FryingItemStack, FryingResult> var2);
    }

    @FunctionalInterface
    public static interface PositionGetter {
        public Vec3 getWorldPositionVector(FryingItemStack var1);
    }

    public static class FryingResult {
        List<FryingItemStack> outputs;
        FryingItemStack heldOutput;
        private static final FryingResult DO_NOTHING = new FryingResult(null, null);
        private static final FryingResult REMOVE_ITEM = new FryingResult((List<FryingItemStack>)ImmutableList.of(), null);

        public static FryingResult doNothing() {
            return DO_NOTHING;
        }

        public static FryingResult removeItem() {
            return REMOVE_ITEM;
        }

        public static FryingResult convertTo(FryingItemStack output) {
            return new FryingResult((List<FryingItemStack>)ImmutableList.of((Object)output), null);
        }

        public static FryingResult convertTo(List<FryingItemStack> outputs) {
            return new FryingResult(outputs, null);
        }

        public static FryingResult convertToAndLeaveHeld(List<FryingItemStack> outputs, FryingItemStack heldOutput) {
            return new FryingResult(outputs, heldOutput);
        }

        private FryingResult(List<FryingItemStack> outputs, FryingItemStack heldOutput) {
            this.outputs = outputs;
            this.heldOutput = heldOutput;
        }

        public boolean doesNothing() {
            return this.outputs == null;
        }

        public boolean didntChangeFrom(ItemStack stackBefore) {
            return this.doesNothing() || this.outputs.size() == 1 && ItemStack.matches((ItemStack)this.outputs.get((int)0).stack, (ItemStack)stackBefore) && !this.hasHeldOutput();
        }

        public List<FryingItemStack> getOutputs() {
            if (this.outputs == null) {
                throw new IllegalStateException("Do not call getOutputs() on a Result that doesNothing().");
            }
            return this.outputs;
        }

        public boolean hasHeldOutput() {
            return this.heldOutput != null;
        }

        @Nullable
        public FryingItemStack getHeldOutput() {
            if (this.heldOutput == null) {
                throw new IllegalStateException("Do not call getHeldOutput() on a Result with hasHeldOutput() == false.");
            }
            return this.heldOutput;
        }
    }
}

