/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.continuousfryer;

import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.box.PackageItem;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingRecipe;

public class FryingItemStack
implements Comparable<FryingItemStack> {
    private static final Random R = new Random();
    public ItemStack stack;
    public float fryerPosition;
    public float sideOffset;
    public int angle;
    public int insertedAt;
    public Direction insertedFrom;
    public boolean locked;
    public boolean lockedExternally;
    public float prevFryerPosition;
    public float prevSideOffset;
    public FryingRecipe lastRecipe;
    public int processingTime;

    public FryingItemStack(ItemStack stack) {
        this.stack = stack;
        boolean centered = BeltHelper.isItemUpright((ItemStack)stack);
        int n = this.angle = centered ? 180 : R.nextInt(360);
        if (PackageItem.isPackage((ItemStack)stack)) {
            this.angle = R.nextInt(4) * 90 + R.nextInt(20) - 10;
        }
        this.sideOffset = this.prevSideOffset = this.getTargetSideOffset();
        this.insertedFrom = Direction.UP;
    }

    public FryingItemStack(TransportedItemStack t) {
        this.stack = t.stack;
        this.fryerPosition = t.beltPosition;
        this.prevFryerPosition = t.prevBeltPosition;
        this.sideOffset = t.sideOffset;
        this.prevSideOffset = t.prevSideOffset;
        this.angle = t.angle;
        this.insertedAt = t.insertedAt;
        this.insertedFrom = t.insertedFrom;
        this.locked = t.locked;
        this.lockedExternally = t.lockedExternally;
        this.processingTime = t.processingTime;
    }

    public float getTargetSideOffset() {
        return (float)(this.angle - 180) / 1080.0f;
    }

    @Override
    public int compareTo(FryingItemStack o) {
        return Float.compare(o.fryerPosition, this.fryerPosition);
    }

    public FryingItemStack getSimilar() {
        FryingItemStack copy = new FryingItemStack(this.stack.copy());
        copy.fryerPosition = this.fryerPosition;
        copy.insertedAt = this.insertedAt;
        copy.insertedFrom = this.insertedFrom;
        copy.prevFryerPosition = this.prevFryerPosition;
        copy.prevSideOffset = this.prevSideOffset;
        copy.processingTime = this.processingTime;
        return copy;
    }

    public FryingItemStack copy() {
        FryingItemStack copy = this.getSimilar();
        copy.angle = this.angle;
        copy.sideOffset = this.sideOffset;
        return copy;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        nbt.put("Item", this.stack.saveOptional(registries));
        nbt.putFloat("Pos", this.fryerPosition);
        nbt.putFloat("PrevPos", this.prevFryerPosition);
        nbt.putFloat("Offset", this.sideOffset);
        nbt.putFloat("PrevOffset", this.prevSideOffset);
        nbt.putInt("InSegment", this.insertedAt);
        nbt.putInt("Angle", this.angle);
        nbt.putInt("InDirection", this.insertedFrom.get3DDataValue());
        nbt.putInt("FryerProcessingTime", this.processingTime);
        if (this.locked) {
            nbt.putBoolean("Locked", this.locked);
        }
        if (this.lockedExternally) {
            nbt.putBoolean("LockedExternally", this.lockedExternally);
        }
        return nbt;
    }

    public static FryingItemStack read(CompoundTag nbt, HolderLookup.Provider registries, Level level) {
        FryingItemStack stack = new FryingItemStack(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("Item")));
        stack.fryerPosition = nbt.getFloat("Pos");
        stack.prevFryerPosition = nbt.getFloat("PrevPos");
        stack.sideOffset = nbt.getFloat("Offset");
        stack.prevSideOffset = nbt.getFloat("PrevOffset");
        stack.insertedAt = nbt.getInt("InSegment");
        stack.angle = nbt.getInt("Angle");
        stack.insertedFrom = Direction.from3DDataValue((int)nbt.getInt("InDirection"));
        stack.locked = nbt.getBoolean("Locked");
        stack.lockedExternally = nbt.getBoolean("LockedExternally");
        stack.processingTime = nbt.getInt("FryerProcessingTime");
        return stack;
    }

    public void clearFryerProcessingData() {
        this.lastRecipe = null;
        this.processingTime = 0;
    }
}

