/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.continuousfryer;

import com.simibubi.create.content.logistics.funnel.AbstractFunnelBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingItemStack;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingItemStackHandlerBehaviour;

public class FryerProcessingBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<FryerProcessingBehaviour> TYPE = new BehaviourType();
    private ProcessingCallback onItemEnter = (s, i) -> ProcessingResult.PASS;
    private ProcessingCallback continueProcessing = (s, i) -> ProcessingResult.PASS;

    public FryerProcessingBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public FryerProcessingBehaviour whenItemEnters(ProcessingCallback callback) {
        this.onItemEnter = callback;
        return this;
    }

    public FryerProcessingBehaviour whileItemHeld(ProcessingCallback callback) {
        this.continueProcessing = callback;
        return this;
    }

    public static boolean isBlocked(BlockGetter world, BlockPos processingSpace) {
        BlockState blockState = world.getBlockState(processingSpace.above());
        if (AbstractFunnelBlock.isFunnel((BlockState)blockState)) {
            return false;
        }
        return !blockState.getCollisionShape(world, processingSpace.above()).isEmpty();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public ProcessingResult handleReceivedItem(FryingItemStack stack, FryingItemStackHandlerBehaviour inventory) {
        return this.onItemEnter.apply(stack, inventory);
    }

    public ProcessingResult handleHeldItem(FryingItemStack stack, FryingItemStackHandlerBehaviour inventory) {
        return this.continueProcessing.apply(stack, inventory);
    }

    @FunctionalInterface
    public static interface ProcessingCallback {
        public ProcessingResult apply(FryingItemStack var1, FryingItemStackHandlerBehaviour var2);
    }

    public static enum ProcessingResult {
        PASS,
        HOLD,
        REMOVE;

    }
}

