/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.continuousfryer;

import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.ContinuousFryerBlockEntity;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerHelper;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerProcessingBehaviour;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingItemStack;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingItemStackHandlerBehaviour;

public class FryerInventory {
    final ContinuousFryerBlockEntity fryer;
    private final List<FryingItemStack> items;
    final List<FryingItemStack> toInsert;
    final List<FryingItemStack> toRemove;
    boolean fryerMovementPositive;
    final float SEGMENT_WINDOW = 0.75f;
    FryingItemStack lazyClientItem;

    public FryerInventory(ContinuousFryerBlockEntity be) {
        this.fryer = be;
        this.items = new LinkedList<FryingItemStack>();
        this.toInsert = new LinkedList<FryingItemStack>();
        this.toRemove = new LinkedList<FryingItemStack>();
    }

    public void tick() {
        if (this.lazyClientItem != null) {
            if (this.lazyClientItem.locked) {
                this.lazyClientItem = null;
            } else {
                this.lazyClientItem.locked = true;
            }
        }
        if (!this.toInsert.isEmpty() || !this.toRemove.isEmpty()) {
            this.toInsert.forEach(this::insert);
            this.toInsert.clear();
            this.items.removeAll(this.toRemove);
            this.toRemove.clear();
            this.fryer.notifyUpdate();
        }
        if (this.fryer.getSpeed() == 0.0f) {
            return;
        }
        if (this.fryerMovementPositive != this.fryer.getDirectionAwareBeltMovementSpeed() > 0.0f) {
            this.fryerMovementPositive = !this.fryerMovementPositive;
            Collections.reverse(this.items);
            this.fryer.notifyUpdate();
        }
        FryingItemStack stackInFront = null;
        FryingItemStack currentItem = null;
        Iterator<FryingItemStack> iterator = this.items.iterator();
        float beltSpeed = this.fryer.getDirectionAwareBeltMovementSpeed();
        Direction movementFacing = this.fryer.getMovementFacing();
        float spacing = 1.0f;
        Level world = this.fryer.getLevel();
        boolean onClient = world.isClientSide && !this.fryer.isVirtual();
        Ending ending = Ending.UNRESOLVED;
        while (iterator.hasNext()) {
            float diffToEnd;
            stackInFront = currentItem;
            currentItem = iterator.next();
            currentItem.prevFryerPosition = currentItem.fryerPosition;
            currentItem.prevSideOffset = currentItem.sideOffset;
            if (currentItem.stack.isEmpty()) {
                iterator.remove();
                currentItem = null;
                continue;
            }
            float movement = beltSpeed;
            if (onClient) {
                movement *= ServerSpeedProvider.get();
            }
            if (world.isClientSide && currentItem.locked) continue;
            if (currentItem.lockedExternally) {
                currentItem.lockedExternally = false;
                continue;
            }
            boolean noMovement = false;
            float currentPos = currentItem.fryerPosition;
            if (stackInFront != null) {
                float diff = stackInFront.fryerPosition - currentPos;
                if (Math.abs(diff) <= spacing) {
                    noMovement = true;
                }
                movement = this.fryerMovementPositive ? Math.min(movement, diff - spacing) : Math.max(movement, diff + spacing);
            }
            float f = diffToEnd = this.fryerMovementPositive ? (float)this.fryer.fryerLength - currentPos : -currentPos;
            if (Math.abs(diffToEnd) < Math.abs(movement) + 1.0f) {
                if (ending == Ending.UNRESOLVED) {
                    ending = this.resolveEnding();
                }
                diffToEnd += this.fryerMovementPositive ? -ending.margin : ending.margin;
            }
            float limitedMovement = this.fryerMovementPositive ? Math.min(movement, diffToEnd) : Math.max(movement, diffToEnd);
            float nextOffset = currentItem.fryerPosition + limitedMovement;
            if (!onClient) {
                ItemStack item = currentItem.stack;
                if (this.handleBeltProcessingAndCheckIfRemoved(currentItem, nextOffset, noMovement)) {
                    iterator.remove();
                    this.fryer.notifyUpdate();
                    continue;
                }
                if (item != currentItem.stack) {
                    this.fryer.notifyUpdate();
                }
                if (currentItem.locked) continue;
            }
            if (noMovement) continue;
            currentItem.fryerPosition += limitedMovement;
            float diffToMiddle = currentItem.getTargetSideOffset() - currentItem.sideOffset;
            currentItem.sideOffset += Mth.clamp((float)(diffToMiddle * Math.abs(limitedMovement) * 6.0f), (float)(-Math.abs(diffToMiddle)), (float)Math.abs(diffToMiddle));
            currentPos = currentItem.fryerPosition;
            if (limitedMovement == movement || onClient) continue;
            int lastOffset = this.fryerMovementPositive ? this.fryer.fryerLength - 1 : 0;
            BlockPos nextPosition = FryerHelper.getPositionForOffset(this.fryer, this.fryerMovementPositive ? this.fryer.fryerLength : -1);
            if (ending == Ending.FUNNEL) continue;
            if (ending == Ending.INSERT) {
                ItemStack remainder;
                DirectBeltInputBehaviour inputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)nextPosition, (BehaviourType)DirectBeltInputBehaviour.TYPE);
                if (inputBehaviour == null || !inputBehaviour.canInsertFromSide(movementFacing) || ItemStack.matches((ItemStack)(remainder = inputBehaviour.handleInsertion(currentItem.stack, movementFacing, false)), (ItemStack)currentItem.stack)) continue;
                currentItem.stack = remainder;
                if (remainder.isEmpty()) {
                    this.lazyClientItem = currentItem;
                    this.lazyClientItem.locked = false;
                    iterator.remove();
                } else {
                    currentItem.stack = remainder;
                }
                this.fryer.notifyUpdate();
                continue;
            }
            if (ending == Ending.BLOCKED || ending != Ending.EJECT) continue;
            this.eject(currentItem);
            iterator.remove();
            this.fryer.notifyUpdate();
        }
    }

    protected boolean handleBeltProcessingAndCheckIfRemoved(FryingItemStack currentItem, float nextOffset, boolean noMovement) {
        int currentSegment = (int)currentItem.fryerPosition;
        if (currentItem.locked) {
            FryerProcessingBehaviour processingBehaviour = this.getBeltProcessingAtSegment(currentSegment);
            FryingItemStackHandlerBehaviour stackHandlerBehaviour = this.getFryingItemStackHandlerAtSegment(currentSegment);
            if (stackHandlerBehaviour == null) {
                return false;
            }
            if (processingBehaviour == null) {
                currentItem.locked = false;
                this.fryer.notifyUpdate();
                return false;
            }
            FryerProcessingBehaviour.ProcessingResult result = processingBehaviour.handleHeldItem(currentItem, stackHandlerBehaviour);
            if (result == FryerProcessingBehaviour.ProcessingResult.REMOVE) {
                return true;
            }
            if (result == FryerProcessingBehaviour.ProcessingResult.HOLD) {
                return false;
            }
            currentItem.locked = false;
            this.fryer.notifyUpdate();
            return false;
        }
        if (noMovement) {
            return false;
        }
        if (currentItem.fryerPosition > 0.5f || this.fryerMovementPositive) {
            int firstUpcomingSegment = (int)(currentItem.fryerPosition + (this.fryerMovementPositive ? 0.5f : -0.5f));
            int step = this.fryerMovementPositive ? 1 : -1;
            int segment = firstUpcomingSegment;
            while (this.fryerMovementPositive ? (float)segment + 0.5f <= nextOffset : (float)segment + 0.5f >= nextOffset) {
                FryerProcessingBehaviour processingBehaviour = this.getBeltProcessingAtSegment(segment);
                FryingItemStackHandlerBehaviour stackHandlerBehaviour = this.getFryingItemStackHandlerAtSegment(segment);
                if (processingBehaviour != null && stackHandlerBehaviour != null && !FryerProcessingBehaviour.isBlocked((BlockGetter)this.fryer.getLevel(), FryerHelper.getPositionForOffset(this.fryer, segment))) {
                    FryerProcessingBehaviour.ProcessingResult result = processingBehaviour.handleReceivedItem(currentItem, stackHandlerBehaviour);
                    if (result == FryerProcessingBehaviour.ProcessingResult.REMOVE) {
                        return true;
                    }
                    if (result == FryerProcessingBehaviour.ProcessingResult.HOLD) {
                        currentItem.fryerPosition = (float)segment + 0.5f + (this.fryerMovementPositive ? 0.001953125f : -0.001953125f);
                        currentItem.locked = true;
                        this.fryer.notifyUpdate();
                        return false;
                    }
                }
                segment += step;
            }
        }
        return false;
    }

    protected FryerProcessingBehaviour getBeltProcessingAtSegment(int segment) {
        return (FryerProcessingBehaviour)BlockEntityBehaviour.get((BlockGetter)this.fryer.getLevel(), (BlockPos)FryerHelper.getPositionForOffset(this.fryer, segment).above(2), FryerProcessingBehaviour.TYPE);
    }

    protected FryingItemStackHandlerBehaviour getFryingItemStackHandlerAtSegment(int segment) {
        return (FryingItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)this.fryer.getLevel(), (BlockPos)FryerHelper.getPositionForOffset(this.fryer, segment), FryingItemStackHandlerBehaviour.TYPE);
    }

    private Ending resolveEnding() {
        BlockPos nextPosition;
        Level world = this.fryer.getLevel();
        DirectBeltInputBehaviour inputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)(nextPosition = FryerHelper.getPositionForOffset(this.fryer, this.fryerMovementPositive ? this.fryer.fryerLength : -1)), (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour != null) {
            return Ending.INSERT;
        }
        if (BlockHelper.hasBlockSolidSide((BlockState)world.getBlockState(nextPosition), (BlockGetter)world, (BlockPos)nextPosition, (Direction)this.fryer.getMovementFacing().getOpposite())) {
            return Ending.BLOCKED;
        }
        return Ending.EJECT;
    }

    public boolean canInsertAt(int segment) {
        return this.canInsertAtFromSide(segment, Direction.UP);
    }

    public boolean canInsertAtFromSide(int segment, Direction side) {
        float segmentPos = segment;
        if (this.fryer.getMovementFacing() == side.getOpposite()) {
            return false;
        }
        if (this.fryer.getMovementFacing() != side) {
            segmentPos += 0.5f;
        } else if (!this.fryerMovementPositive) {
            segmentPos += 1.0f;
        }
        for (FryingItemStack stack : this.items) {
            if (!this.isBlocking(segment, side, segmentPos, stack)) continue;
            return false;
        }
        for (FryingItemStack stack : this.toInsert) {
            if (!this.isBlocking(segment, side, segmentPos, stack)) continue;
            return false;
        }
        return true;
    }

    private boolean isBlocking(int segment, Direction side, float segmentPos, FryingItemStack stack) {
        float currentPos = stack.fryerPosition;
        return stack.insertedAt == segment && stack.insertedFrom == side && (this.fryerMovementPositive ? currentPos <= segmentPos + 1.0f : currentPos >= segmentPos - 1.0f);
    }

    public void addItem(FryingItemStack newStack) {
        this.toInsert.add(newStack);
    }

    private void insert(FryingItemStack newStack) {
        if (this.items.isEmpty()) {
            this.items.add(newStack);
        } else {
            int index = 0;
            for (FryingItemStack stack : this.items) {
                if (stack.compareTo(newStack) > 0 == this.fryerMovementPositive) break;
                ++index;
            }
            this.items.add(index, newStack);
        }
    }

    public FryingItemStack getStackAtOffset(int offset) {
        float min = offset;
        float max = offset + 1;
        for (FryingItemStack stack : this.items) {
            if (this.toRemove.contains(stack) || stack.fryerPosition > max || !(stack.fryerPosition > min)) continue;
            return stack;
        }
        return null;
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, Level level) {
        this.items.clear();
        nbt.getList("Items", 10).forEach(inbt -> this.items.add(FryingItemStack.read((CompoundTag)inbt, registries, level)));
        if (nbt.contains("LazyItem")) {
            this.lazyClientItem = FryingItemStack.read(nbt.getCompound("LazyItem"), registries, level);
        }
        this.fryerMovementPositive = nbt.getBoolean("PositiveOrder");
    }

    public CompoundTag write(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        ListTag itemsNBT = new ListTag();
        this.items.forEach(stack -> itemsNBT.add((Object)stack.serializeNBT(registries)));
        nbt.put("Items", (Tag)itemsNBT);
        if (this.lazyClientItem != null) {
            nbt.put("LazyItem", (Tag)this.lazyClientItem.serializeNBT(registries));
        }
        nbt.putBoolean("PositiveOrder", this.fryerMovementPositive);
        return nbt;
    }

    public void eject(FryingItemStack stack) {
        ItemStack ejected = stack.stack;
        Vec3 outPos = FryerHelper.getVectorForOffset(this.fryer, stack.fryerPosition);
        float movementSpeed = Math.max(Math.abs(this.fryer.getFryerMovementSpeed()), 0.125f);
        Vec3 outMotion = Vec3.atLowerCornerOf((Vec3i)this.fryer.getFryerChainDirection()).scale((double)movementSpeed).add(0.0, 0.125, 0.0);
        outPos = outPos.add(outMotion.normalize().scale(0.001));
        ItemEntity entity = new ItemEntity(this.fryer.getLevel(), outPos.x, outPos.y + 0.375, outPos.z, ejected);
        entity.setDeltaMovement(outMotion);
        entity.setDefaultPickUpDelay();
        entity.hurtMarked = true;
        this.fryer.getLevel().addFreshEntity((Entity)entity);
    }

    public void ejectAll() {
        this.items.forEach(this::eject);
        this.items.clear();
    }

    public void clear() {
        this.items.clear();
        this.toInsert.clear();
        this.toRemove.clear();
        this.lazyClientItem = null;
    }

    public void applyToEachWithin(float position, float maxDistanceToPosition, Function<FryingItemStack, FryingItemStackHandlerBehaviour.FryingResult> processFunction) {
        boolean dirty = false;
        for (FryingItemStack transported : this.items) {
            FryingItemStackHandlerBehaviour.FryingResult result;
            if (this.toRemove.contains(transported)) continue;
            ItemStack stackBefore = transported.stack.copy();
            if (Math.abs(position - transported.fryerPosition) >= maxDistanceToPosition || (result = processFunction.apply(transported)) == null || result.didntChangeFrom(stackBefore)) continue;
            dirty = true;
            if (result.hasHeldOutput()) {
                FryingItemStack held = result.getHeldOutput();
                held.fryerPosition = (float)((int)position) + 0.5f - (this.fryerMovementPositive ? 0.001953125f : -0.001953125f);
                this.toInsert.add(held);
            }
            this.toInsert.addAll(result.getOutputs());
            this.toRemove.add(transported);
        }
        if (dirty) {
            this.fryer.notifyUpdate();
        }
    }

    public List<FryingItemStack> getTransportedItems() {
        return this.items;
    }

    @Nullable
    public FryingItemStack getLazyClientItem() {
        return this.lazyClientItem;
    }

    private static enum Ending {
        UNRESOLVED(0.0f),
        EJECT(0.0f),
        INSERT(0.25f),
        FUNNEL(0.5f),
        BLOCKED(0.45f);

        private float margin;

        private Ending(float f) {
            this.margin = f;
        }
    }
}

