/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.continuousfryer;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.processing.burner.ScrollInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.ContinuousFryerBlock;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.ContinuousFryerBlockEntity;
import org.starfruit.ratatouillefrieddelights.entry.RFDPartialModels;
import org.starfruit.ratatouillefrieddelights.entry.RFDSpriteShifts;

public class ContinuousFryerVisual
extends KineticBlockEntityVisual<ContinuousFryerBlockEntity> {
    public static final float MAGIC_SCROLL_MULTIPLIER = 0.001984127f;
    public static final float SCROLL_FACTOR_OTHERWISE = 0.5f;
    public static final float SCROLL_OFFSET_OTHERWISE = 0.0f;
    @Nullable
    protected final RotatingInstance axis;
    final Direction direction;
    protected final ScrollInstance belt;

    public ContinuousFryerVisual(VisualizationContext context, ContinuousFryerBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        BlockState referenceState = blockEntity.getBlockState();
        Direction facing = ((Direction)referenceState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise();
        Instancer beltModel = this.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial((PartialModel)RFDPartialModels.FRYER_BELT));
        this.belt = this.setup((ScrollInstance)beltModel.createInstance());
        this.direction = (Direction)this.blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (blockEntity.shouldRenderAxis()) {
            this.axis = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)RFDPartialModels.FRYER_AXIS)).createInstance();
            this.axis.setup((KineticBlockEntity)blockEntity, facing.getAxis(), ((ContinuousFryerBlockEntity)this.blockEntity).getSpeed()).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.direction).setChanged();
        } else {
            this.axis = null;
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        if (this.axis != null) {
            consumer.accept((Instance)this.axis);
        }
        consumer.accept((Instance)this.belt);
    }

    public void update(float partialTick) {
        if (this.axis != null) {
            this.axis.setup((KineticBlockEntity)this.blockEntity, ((ContinuousFryerBlockEntity)this.blockEntity).getSpeed()).setChanged();
        }
        this.setup(this.belt);
    }

    public void updateLight(float partialTick) {
        BlockPos inFront = this.pos.relative(this.direction);
        if (this.axis != null) {
            this.relight(inFront, new FlatLit[]{this.axis});
        }
        this.relight(new FlatLit[]{this.belt});
    }

    protected void _delete() {
        if (this.axis != null) {
            this.axis.delete();
        }
        this.belt.delete();
    }

    private ScrollInstance setup(ScrollInstance key) {
        Direction facing = ((Direction)this.blockState.getValue(ContinuousFryerBlock.HORIZONTAL_FACING)).getAxis() == Direction.Axis.X ? Direction.EAST : Direction.SOUTH;
        boolean alongX = facing.getAxis() == Direction.Axis.X;
        float speed = ((ContinuousFryerBlockEntity)this.blockEntity).getSpeed();
        if (facing.getAxisDirection() == Direction.AxisDirection.NEGATIVE ^ alongX) {
            speed = -speed;
        }
        speed = -speed;
        float rotX = 0.0f;
        float rotY = facing.toYRot() + (float)(alongX ? 180 : 0);
        float rotZ = 0.0f;
        Quaternionf q = new Quaternionf().rotationXYZ(rotX * ((float)Math.PI / 180), rotY * ((float)Math.PI / 180), rotZ * ((float)Math.PI / 180));
        key.setSpriteShift(RFDSpriteShifts.FRYER_BELT, 1.0f, 0.5f).position((Vec3i)this.getVisualPosition()).rotation((Quaternionfc)q).speed(0.0f, speed * 0.001984127f).offset(0.0f, 0.0f).colorRgb(RotatingInstance.colorFromBE((KineticBlockEntity)((KineticBlockEntity)this.blockEntity))).setChanged();
        return key;
    }
}

