/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.continuousfryer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.render.ShadowRenderHelper;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Random;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.ContinuousFryerBlock;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.ContinuousFryerBlockEntity;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerInventory;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingItemStack;
import org.starfruit.ratatouillefrieddelights.entry.RFDPartialModels;
import org.starfruit.ratatouillefrieddelights.entry.RFDSpriteShifts;

public class ContinuousFryerRenderer
extends KineticBlockEntityRenderer<ContinuousFryerBlockEntity> {
    public ContinuousFryerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRenderOffScreen(ContinuousFryerBlockEntity be) {
        return be.isController();
    }

    protected SuperByteBuffer getRotatedModel(ContinuousFryerBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacingVertical((PartialModel)RFDPartialModels.FRYER_AXIS, (BlockState)state, (Direction)((Direction)state.getValue(ContinuousFryerBlock.HORIZONTAL_FACING)));
    }

    protected void renderSafe(ContinuousFryerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            BlockState blockState = be.getBlockState();
            Direction facing = (Direction)blockState.getValue(ContinuousFryerBlock.HORIZONTAL_FACING);
            Direction.AxisDirection axisDirection = facing.getAxisDirection();
            boolean sideways = false;
            boolean alongX = facing.getAxis() == Direction.Axis.X;
            PoseStack localTransforms = new PoseStack();
            PoseTransformStack msr = TransformStack.of((PoseStack)localTransforms);
            VertexConsumer vb = buffer.getBuffer(RenderType.solid());
            float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)msr.center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing) + 0.0f + 0.0f)).rotateZDegrees(0.0f)).rotateXDegrees(0.0f)).uncenter();
            for (boolean bottom : Iterate.trueAndFalse) {
                PartialModel beltPartial = RFDPartialModels.FRYER_BELT;
                SuperByteBuffer beltBuffer = CachedBuffers.partial((PartialModel)beltPartial, (BlockState)blockState).light(light);
                SpriteShiftEntry spriteShift = RFDSpriteShifts.FRYER_BELT;
                float speed = be.getSpeed();
                if (speed != 0.0f) {
                    float time = renderTick * (float)axisDirection.getStep();
                    if (!sideways && alongX) {
                        speed = -speed;
                    }
                    float scrollMult = 0.5f;
                    float spriteSize = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
                    double scroll = (double)(speed * time) / 504.0 + (bottom ? 0.5 : 0.0);
                    scroll -= Math.floor(scroll);
                    scroll = scroll * (double)spriteSize * (double)scrollMult;
                    beltBuffer.shiftUVScrolling(spriteShift, (float)scroll);
                }
                ((SuperByteBuffer)beltBuffer.transform(localTransforms)).renderInto(ms, vb);
            }
        }
        this.renderFluid(be, partialTicks, ms, buffer, light, overlay);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
    }

    private void renderFluid(ContinuousFryerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float zMax;
        float zMin;
        float xMax;
        float xMin;
        if (!be.isController()) {
            return;
        }
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float level = fluidLevel.getValue(partialTicks);
        if (level <= 0.0f) {
            return;
        }
        FluidTank tank = be.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        float tankHullWidth = 0.125f;
        float maxFluidHeight = 0.40625f;
        float fluidHeight = maxFluidHeight * Mth.clamp((float)level, (float)0.0f, (float)1.0f);
        Direction facing = be.getFryerFacing();
        boolean alongX = facing.getAxis() == Direction.Axis.X;
        float length = be.fryerLength;
        float width = 1.0f;
        if (alongX) {
            xMin = tankHullWidth;
            xMax = length - tankHullWidth;
            zMin = tankHullWidth;
            zMax = width - tankHullWidth;
        } else {
            xMin = tankHullWidth;
            xMax = width - tankHullWidth;
            zMin = tankHullWidth;
            zMax = length - tankHullWidth;
        }
        float yMin = 0.3125f;
        float yMax = yMin + fluidHeight;
        ms.pushPose();
        NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false, true);
        ms.popPose();
    }

    protected void renderItems(ContinuousFryerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        if (be.fryerLength == 0) {
            return;
        }
        ms.pushPose();
        Direction beltFacing = be.getFryerFacing();
        Vec3i directionVec = beltFacing.getNormal();
        Vec3 beltStartOffset = Vec3.atLowerCornerOf((Vec3i)directionVec).scale(-0.5).add(0.5, 0.8125, 0.5);
        ms.translate(beltStartOffset.x, beltStartOffset.y, beltStartOffset.z);
        int verticality = 0;
        boolean slopeAlongX = beltFacing.getAxis() == Direction.Axis.X;
        boolean onContraption = be.getLevel() instanceof WrappedLevel;
        FryerInventory inventory = be.getItemInventory();
        for (FryingItemStack transported : inventory.getTransportedItems()) {
            this.renderItem(be, partialTicks, ms, buffer, light, overlay, beltFacing, directionVec, verticality, slopeAlongX, onContraption, transported, beltStartOffset);
        }
        if (inventory.getLazyClientItem() != null) {
            this.renderItem(be, partialTicks, ms, buffer, light, overlay, beltFacing, directionVec, verticality, slopeAlongX, onContraption, inventory.getLazyClientItem(), beltStartOffset);
        }
        ms.popPose();
    }

    private void renderItem(ContinuousFryerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, Direction beltFacing, Vec3i directionVec, int verticality, boolean slopeAlongX, boolean onContraption, FryingItemStack transported, Vec3 beltStartOffset) {
        int stackLight;
        boolean alongX;
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer itemRenderer = mc.getItemRenderer();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        float offset = Mth.lerp((float)partialTicks, (float)transported.prevFryerPosition, (float)transported.fryerPosition);
        float sideOffset = Mth.lerp((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
        float verticalMovement = verticality;
        if (be.getSpeed() == 0.0f) {
            offset = transported.fryerPosition;
            sideOffset = transported.sideOffset;
        }
        verticalMovement = (double)offset < 0.5 ? 0.0f : (float)verticality * (Math.min(offset, (float)be.fryerLength - 0.5f) - 0.5f);
        Vec3 offsetVec = Vec3.atLowerCornerOf((Vec3i)directionVec).scale((double)offset);
        if (verticalMovement != 0.0f) {
            offsetVec = offsetVec.add(0.0, (double)verticalMovement, 0.0);
        }
        float slopeAngle = 0.0f;
        Vec3 itemPos = beltStartOffset.add((double)be.getBlockPos().getX(), (double)be.getBlockPos().getY(), (double)be.getBlockPos().getZ()).add(offsetVec);
        if (this.shouldCullItem(itemPos, be.getLevel())) {
            return;
        }
        ms.pushPose();
        TransformStack.of((PoseStack)ms).nudge(transported.angle);
        ms.translate(offsetVec.x, offsetVec.y, offsetVec.z);
        boolean bl = alongX = beltFacing.getClockWise().getAxis() == Direction.Axis.X;
        if (!alongX) {
            sideOffset *= -1.0f;
        }
        ms.translate(alongX ? sideOffset : 0.0f, 0.0f, alongX ? 0.0f : sideOffset);
        if (onContraption) {
            stackLight = light;
        } else {
            int segment = (int)Math.floor(offset);
            mutablePos.set((Vec3i)be.getBlockPos()).move(directionVec.getX() * segment, verticality * segment, directionVec.getZ() * segment);
            stackLight = LevelRenderer.getLightColor((BlockAndTintGetter)be.getLevel(), (BlockPos)mutablePos);
        }
        boolean renderUpright = false;
        BakedModel bakedModel = itemRenderer.getModel(transported.stack, be.getLevel(), null, 0);
        boolean blockItem = bakedModel.isGui3d();
        int count = 0;
        if (be.getLevel() instanceof PonderLevel || mc.player.getEyePosition(1.0f).distanceTo(itemPos) < 16.0) {
            count = Mth.log2((int)transported.stack.getCount()) / 2;
        }
        Random r = new Random(transported.angle);
        ms.mulPose((slopeAlongX ? Axis.ZP : Axis.XP).rotationDegrees(slopeAngle));
        ms.pushPose();
        ms.translate(0.0f, -0.12f, 0.0f);
        ShadowRenderHelper.renderShadow((PoseStack)ms, (MultiBufferSource)buffer, (float)0.75f, (float)0.2f);
        ms.popPose();
        for (int i = 0; i <= count; ++i) {
            ms.pushPose();
            boolean box = PackageItem.isPackage((ItemStack)transported.stack);
            ms.mulPose(Axis.YP.rotationDegrees((float)transported.angle));
            if (!blockItem && !renderUpright) {
                ms.translate(0.0, -0.09375, 0.0);
                ms.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            if (blockItem && !box) {
                ms.translate(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
            }
            if (box) {
                ms.translate(0.0f, 0.25f, 0.0f);
                ms.scale(1.5f, 1.5f, 1.5f);
            } else {
                ms.scale(0.5f, 0.5f, 0.5f);
            }
            itemRenderer.render(transported.stack, ItemDisplayContext.FIXED, false, ms, buffer, stackLight, overlay, bakedModel);
            ms.popPose();
            if (!renderUpright) {
                if (!blockItem) {
                    ms.mulPose(Axis.YP.rotationDegrees(10.0f));
                }
                ms.translate(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                continue;
            }
            ms.translate(0.0f, 0.0f, -0.0625f);
        }
        ms.popPose();
    }
}

