/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.continuousfryer;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.starfruit.ratatouillefrieddelights.config.RFDConfigs;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.ContinuousFryerBlock;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerHelper;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerInventory;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerMovementHandler;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerPart;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingItemStack;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingItemStackHandlerBehaviour;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingRecipe;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.ItemHandlerFryerSegment;
import org.starfruit.ratatouillefrieddelights.entry.RFDBlockEntityTypes;
import org.starfruit.ratatouillefrieddelights.entry.RFDItems;
import org.starfruit.ratatouillefrieddelights.entry.RFDRecipeTypes;
import org.starfruit.ratatouillefrieddelights.util.Lang;

public class ContinuousFryerBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public Map<Entity, FryerMovementHandler.FringEntityInfo> passengers;
    private FryingRecipe lastRecipe;
    private int overFryingTime = 500;
    public int fryerLength;
    public int index;
    protected BlockPos controller;
    protected IFluidHandler fluidHandler;
    protected FluidTank tankInventory = this.createTankInventory();
    protected FryerInventory itemInventory;
    protected IItemHandler itemHandler;
    public VersionedInventoryTrackerBehaviour invVersionTracker;
    private LerpedFloat fluidLevel;
    protected boolean forceFluidLevelUpdate = true;
    private boolean updateConnectivity = true;

    public ContinuousFryerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static int getFryerCapacityMultiplier() {
        return (Integer)RFDConfigs.server().fluids.fryerTankCapacity.get() * 1000;
    }

    protected SmartFluidTank createTankInventory() {
        return new SmartFluidTank(ContinuousFryerBlockEntity.getFryerCapacityMultiplier(), this::onFluidStackChanged);
    }

    public AABB createRenderBoundingBox() {
        if (!this.isController()) {
            return super.createRenderBoundingBox();
        }
        return super.createRenderBoundingBox().inflate((double)(this.fryerLength + 1));
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * ContinuousFryerBlockEntity.getFryerCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ContinuousFryerBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null || this.level == null) {
            return false;
        }
        this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)controllerBE.tankInventory);
        BlazeBurnerBlock.HeatLevel heatLevel = controllerBE.getHeatLevel();
        Lang.translate("fryer.heat_level", new Object[0]).forGoggles(tooltip);
        Lang.translate("fryer." + heatLevel.getSerializedName(), new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    private List<ContinuousFryerBlockEntity> getConnectedChain() {
        if (this.level == null) {
            return List.of(this);
        }
        ContinuousFryerBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return List.of(this);
        }
        Direction.Axis axis = controller.getFryerFacing().getAxis();
        ArrayList<ContinuousFryerBlockEntity> chain = new ArrayList<ContinuousFryerBlockEntity>();
        BlockPos cursor = controller.getBlockPos();
        for (int i = 0; i < controller.fryerLength; ++i) {
            BlockEntity be = this.level.getBlockEntity(cursor);
            if (be instanceof ContinuousFryerBlockEntity) {
                ContinuousFryerBlockEntity fryer = (ContinuousFryerBlockEntity)be;
                chain.add(fryer);
            }
            cursor = axis == Direction.Axis.X ? cursor.east() : cursor.south();
        }
        return chain;
    }

    public void destroy() {
        super.destroy();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.split(true);
    }

    public void split(boolean dropContents) {
        ContinuousFryerBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        FryerInventory itemInv = controllerBE.getItemInventory();
        if (itemInv == null) {
            return;
        }
        List<FryingItemStack> allItems = itemInv.getTransportedItems();
        if (allItems == null) {
            return;
        }
        allItems = new ArrayList<FryingItemStack>(allItems);
        FluidStack totalFluid = controllerBE.tankInventory.getFluid();
        int totalAmount = totalFluid.getAmount();
        if (dropContents) {
            ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)new ItemHandlerFryerSegment(itemInv, this.index));
        }
        List<ContinuousFryerBlockEntity> chain = controllerBE.getConnectedChain();
        for (ContinuousFryerBlockEntity fryer : chain) {
            fryer.itemInventory = new FryerInventory(fryer);
            fryer.tankInventory = fryer.createTankInventory();
            if (totalAmount <= 0 || dropContents && fryer == this) continue;
            int fillAmount = Math.min(totalAmount, fryer.tankInventory.getCapacity());
            fryer.tankInventory.setFluid(new FluidStack(totalFluid.getFluid(), fillAmount));
            totalAmount -= fillAmount;
        }
        for (FryingItemStack item : allItems) {
            float globalPos = item.fryerPosition;
            int segmentIndex = Mth.clamp((int)((int)globalPos), (int)0, (int)(chain.size() - 1));
            float localPos = globalPos - (float)segmentIndex;
            ContinuousFryerBlockEntity target = chain.get(segmentIndex);
            target.setController(target.worldPosition);
            item.fryerPosition = localPos;
            item.prevFryerPosition = localPos;
            item.insertedAt = 0;
            item.locked = false;
            item.lockedExternally = false;
            FryerInventory targetInv = target.getItemInventory();
            targetInv.getTransportedItems().add(item);
            targetInv.getTransportedItems().sort((a, b) -> Float.compare(b.fryerPosition, a.fryerPosition));
        }
        this.updateNeighbours();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)RFDBlockEntityTypes.CONTINUOUS_FRYER.get(), (be, context) -> {
            be.initCapability();
            return be.fluidHandler;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RFDBlockEntityTypes.CONTINUOUS_FRYER.get(), (be, context) -> {
            be.initCapability();
            return be.itemHandler;
        });
    }

    void refreshCapability() {
        this.fluidHandler = null;
        this.itemHandler = null;
        this.invalidateCapabilities();
    }

    void initCapability() {
        if (this.itemHandler != null && this.fluidHandler != null || this.level == null) {
            return;
        }
        if (!this.isController()) {
            ContinuousFryerBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemHandler = new ItemHandlerFryerSegment(controllerBE.getItemInventory(), this.index);
            this.fluidHandler = controllerBE.fluidHandler;
            return;
        }
        this.fluidHandler = this.tankInventory;
        this.itemHandler = new ItemHandlerFryerSegment(this.getItemInventory(), this.index);
    }

    public FryerInventory getItemInventory() {
        if (!this.isController()) {
            ContinuousFryerBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE != null) {
                return controllerBE.getItemInventory();
            }
            return null;
        }
        if (this.itemInventory == null) {
            this.itemInventory = new FryerInventory(this);
        }
        return this.itemInventory;
    }

    public boolean shouldRenderAxis() {
        BlockState state = this.getBlockState();
        if (!state.hasProperty(ContinuousFryerBlock.PART)) {
            return false;
        }
        FryerPart part = (FryerPart)((Object)state.getValue(ContinuousFryerBlock.PART));
        return part == FryerPart.END || part == FryerPart.SINGLE;
    }

    public ContinuousFryerBlockEntity getControllerBE() {
        if (this.controller == null || this.level == null) {
            return null;
        }
        if (!this.level.isLoaded(this.controller)) {
            return null;
        }
        BlockEntity be = this.level.getBlockEntity(this.controller);
        if (!(be instanceof ContinuousFryerBlockEntity)) {
            return null;
        }
        return (ContinuousFryerBlockEntity)be;
    }

    public void setController(BlockPos controller) {
        if (this.level == null || this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.refreshCapability();
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public BlockPos getController() {
        return this.controller == null ? this.worldPosition : this.controller;
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof ContinuousFryerBlockEntity) {
            ContinuousFryerBlockEntity fryer = (ContinuousFryerBlockEntity)target;
            if (!connectedViaAxes) {
                Direction.Axis axis2;
                if (!this.getController().equals((Object)fryer.getController())) {
                    return 0.0f;
                }
                Direction.Axis axis1 = ((Direction)stateFrom.getValue(ContinuousFryerBlock.HORIZONTAL_FACING)).getAxis();
                if (axis1 != (axis2 = ((Direction)stateTo.getValue(ContinuousFryerBlock.HORIZONTAL_FACING)).getAxis())) {
                    return 0.0f;
                }
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public boolean isController() {
        return this.controller != null && this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public void updateConnectivity() {
        Direction.Axis otherAxis;
        BlockState state;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = false;
        Direction.Axis axis = ((Direction)this.getBlockState().getValue(ContinuousFryerBlock.HORIZONTAL_FACING)).getAxis();
        ArrayList<BlockPos> chain = new ArrayList<BlockPos>();
        chain.add(this.worldPosition);
        BlockPos cursor = this.worldPosition;
        while ((state = this.level.getBlockState(cursor = axis == Direction.Axis.X ? cursor.east() : cursor.south())).getBlock() instanceof ContinuousFryerBlock && (otherAxis = ((Direction)state.getValue(ContinuousFryerBlock.HORIZONTAL_FACING)).getAxis()) == axis) {
            chain.add(cursor);
        }
        cursor = this.worldPosition;
        while ((state = this.level.getBlockState(cursor = axis == Direction.Axis.X ? cursor.west() : cursor.north())).getBlock() instanceof ContinuousFryerBlock && (otherAxis = ((Direction)state.getValue(ContinuousFryerBlock.HORIZONTAL_FACING)).getAxis()) == axis) {
            chain.addFirst(cursor);
        }
        ArrayList<FryingItemStack> mergedItems = new ArrayList<FryingItemStack>();
        int length = chain.size();
        for (int i = 0; i < length; ++i) {
            List<FryingItemStack> stacks;
            FryerInventory inv;
            BlockState old;
            BlockPos pos = (BlockPos)chain.get(i);
            BlockEntity be = this.level.getBlockEntity(pos);
            if (!(be instanceof ContinuousFryerBlockEntity)) continue;
            ContinuousFryerBlockEntity fryer = (ContinuousFryerBlockEntity)be;
            fryer.fryerLength = length;
            fryer.index = i;
            fryer.setController((BlockPos)chain.getFirst());
            FryerPart part = length == 1 ? FryerPart.SINGLE : (i == 0 || i == length - 1 ? FryerPart.END : FryerPart.MIDDLE);
            BlockState newState = old = this.level.getBlockState(pos);
            if (old.getValue(ContinuousFryerBlock.PART) != part) {
                newState = (BlockState)newState.setValue(ContinuousFryerBlock.PART, (Comparable)((Object)part));
            }
            if (part == FryerPart.END) {
                if (i == 0) {
                    facing = axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH;
                    newState = (BlockState)newState.setValue(ContinuousFryerBlock.HORIZONTAL_FACING, (Comparable)facing);
                } else if (i == length - 1) {
                    facing = axis == Direction.Axis.X ? Direction.WEST : Direction.NORTH;
                    newState = (BlockState)newState.setValue(ContinuousFryerBlock.HORIZONTAL_FACING, (Comparable)facing);
                }
            }
            if ((inv = fryer.itemInventory) != null && (stacks = inv.getTransportedItems()) != null && !stacks.isEmpty()) {
                for (FryingItemStack stack : stacks) {
                    float globalPos;
                    float localPos = stack.fryerPosition;
                    stack.fryerPosition = globalPos = (float)i + localPos;
                    stack.prevFryerPosition = globalPos;
                    stack.locked = false;
                    stack.lockedExternally = false;
                    stack.insertedAt = i;
                    mergedItems.add(stack);
                }
            }
            fryer.itemInventory = null;
            fryer.updateConnectivity = false;
            this.level.setBlock(pos, newState, 6);
            fryer.detachKinetics();
            fryer.clearKineticInformation();
            fryer.attachKinetics();
            fryer.refreshCapability();
            fryer.requestModelDataUpdate();
            fryer.notifyUpdate();
        }
        ContinuousFryerBlockEntity controllerBE = (ContinuousFryerBlockEntity)this.level.getBlockEntity((BlockPos)chain.getFirst());
        if (controllerBE != null) {
            FryerInventory controllerInv = controllerBE.getItemInventory();
            controllerInv.getTransportedItems().clear();
            controllerInv.getTransportedItems().addAll(mergedItems);
            FluidStack mergedFluid = FluidStack.EMPTY;
            for (BlockPos fryerPos : chain) {
                BlockEntity be = this.level.getBlockEntity(fryerPos);
                if (!(be instanceof ContinuousFryerBlockEntity)) continue;
                ContinuousFryerBlockEntity fryer = (ContinuousFryerBlockEntity)be;
                FluidTank tank = fryer.tankInventory;
                if (tank == null || tank.getFluid().isEmpty()) continue;
                FluidStack fluid = tank.getFluid();
                if (mergedFluid.isEmpty()) {
                    mergedFluid = fluid.copy();
                } else if (mergedFluid.getFluid().isSame(fluid.getFluid())) {
                    mergedFluid.grow(fluid.getAmount());
                }
                tank.setFluid(FluidStack.EMPTY);
            }
            controllerBE.applyFluidTankSize(length);
            if (!mergedFluid.isEmpty()) {
                int capacity = controllerBE.tankInventory.getCapacity();
                if (mergedFluid.getAmount() > capacity) {
                    mergedFluid.setAmount(capacity);
                }
                controllerBE.tankInventory.setFluid(mergedFluid);
            }
            controllerBE.notifyUpdate();
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).onlyInsertWhen(this::canInsertFrom).setInsertionHandler(this::tryInsertingFromSide).considerOccupiedWhen(this::isOccupied));
        behaviours.add(new FryingItemStackHandlerBehaviour((SmartBlockEntity)this, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf));
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
    }

    private Vec3 getWorldPositionOf(FryingItemStack transported) {
        ContinuousFryerBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return Vec3.ZERO;
        }
        return FryerHelper.getVectorForOffset(controllerBE, transported.fryerPosition);
    }

    private void applyToAllItems(float maxDistanceFromCenter, Function<FryingItemStack, FryingItemStackHandlerBehaviour.FryingResult> processFunction) {
        ContinuousFryerBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return;
        }
        FryerInventory inventory = controller.getItemInventory();
        if (inventory != null) {
            inventory.applyToEachWithin((float)this.index + 0.5f, maxDistanceFromCenter, processFunction);
        }
    }

    private boolean canInsertFrom(Direction side) {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        return this.getMovementFacing() != side.getOpposite();
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ContinuousFryerBlockEntity nextBeltController = this.getControllerBE();
        ItemStack inserted = transportedStack.stack;
        ItemStack empty = ItemStack.EMPTY;
        if (nextBeltController == null) {
            return inserted;
        }
        FryerInventory nextInventory = nextBeltController.getItemInventory();
        if (nextInventory == null) {
            return inserted;
        }
        if (this.isOccupied(side)) {
            return inserted;
        }
        if (simulate) {
            return empty;
        }
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = (float)this.index + 0.5f - Math.signum(this.getDirectionAwareBeltMovementSpeed()) / 16.0f;
        Direction movementFacing = this.getMovementFacing();
        if (!side.getAxis().isVertical()) {
            if (movementFacing != side) {
                transportedStack.sideOffset = (float)side.getAxisDirection().getStep() * 0.675f;
                if (side.getAxis() == Direction.Axis.X) {
                    transportedStack.sideOffset *= -1.0f;
                }
            } else {
                float extraOffset = transportedStack.prevBeltPosition != 0.0f && FryerHelper.getSegmentBE((LevelAccessor)this.level, this.worldPosition.relative(movementFacing.getOpposite())) != null ? 0.26f : 0.0f;
                transportedStack.beltPosition = this.getDirectionAwareBeltMovementSpeed() > 0.0f ? (float)this.index - extraOffset : (float)(this.index + 1) + extraOffset;
            }
        }
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.insertedAt = this.index;
        transportedStack.insertedFrom = side;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        nextInventory.addItem(new FryingItemStack(transportedStack));
        nextBeltController.setChanged();
        nextBeltController.sendData();
        return empty;
    }

    private boolean isOccupied(Direction side) {
        ContinuousFryerBlockEntity nextBeltController = this.getControllerBE();
        if (nextBeltController == null) {
            return true;
        }
        FryerInventory nextInventory = nextBeltController.getItemInventory();
        if (nextInventory == null) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.getMovementFacing() == side.getOpposite()) {
            return true;
        }
        return !nextInventory.canInsertAtFromSide(this.index, side);
    }

    public Direction getFryerFacing() {
        return (Direction)this.getBlockState().getValue(ContinuousFryerBlock.HORIZONTAL_FACING);
    }

    public void updateNeighbours() {
        if (this.level == null) {
            return;
        }
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            ContinuousFryerBlockEntity fryer;
            BlockEntity fryerBe;
            BlockPos neighbourPos = this.worldPosition.relative(dir);
            BlockState neighbourState = this.level.getBlockState(neighbourPos);
            if (!(neighbourState.getBlock() instanceof ContinuousFryerBlock) || !((fryerBe = this.level.getBlockEntity(neighbourPos)) instanceof ContinuousFryerBlockEntity) || (fryer = (ContinuousFryerBlockEntity)fryerBe).isRemoved()) continue;
            fryer.updateConnectivity();
        }
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    public void tick() {
        if (!(this.level == null || this.level.isClientSide || this.getControllerBE() != null && this.getFryerFacing().getAxis() == this.getControllerBE().getFryerFacing().getAxis())) {
            this.setController(this.worldPosition);
            this.updateConnectivity();
            this.updateNeighbours();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        super.tick();
        if (!this.isController()) {
            return;
        }
        this.invalidateRenderBoundingBox();
        this.getItemInventory().tick();
        if (this.level != null && this.level.isClientSide) {
            if (!this.isVirtual()) {
                this.spawnFryerParticles();
            }
            return;
        }
        this.tickPassengers();
        this.tickFryingItems();
    }

    private void tickPassengers() {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.passengers == null) {
            this.passengers = new HashMap<Entity, FryerMovementHandler.FringEntityInfo>();
        }
        ArrayList toRemove = new ArrayList();
        this.passengers.forEach((entity, info) -> {
            boolean leftTheBelt;
            boolean canBeTransported = FryerMovementHandler.canBeTransported(entity);
            boolean bl = leftTheBelt = info.getTicksSinceLastCollision() > 1;
            if (!canBeTransported || leftTheBelt) {
                toRemove.add(entity);
                return;
            }
            info.tick();
            FryerMovementHandler.transportEntity(this, entity, info);
        });
        toRemove.forEach(this.passengers::remove);
    }

    private void spawnFryerParticles() {
        FryerInventory inventory;
        if (this.level == null || !this.level.isClientSide || this.fluidNotSufficient()) {
            return;
        }
        RandomSource random = this.level.getRandom();
        BlazeBurnerBlock.HeatLevel heatLevel = this.getHeatLevel();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        if (!this.tankInventory.isEmpty()) {
            for (ContinuousFryerBlockEntity fryer : this.getConnectedChain()) {
                if (random.nextInt(5) != 0) continue;
                Vec3 pos = Vec3.atCenterOf((Vec3i)fryer.getBlockPos()).add((random.nextDouble() - 0.5) * 0.5, 0.5, (random.nextDouble() - 0.5) * 0.5);
                this.level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, pos.x, pos.y, pos.z, 0.0, 0.05, 0.0);
            }
        }
        if ((inventory = this.getItemInventory()) != null) {
            for (FryingItemStack item : inventory.getTransportedItems()) {
                if (random.nextInt(3) != 0) continue;
                Vec3 itemPos = this.getWorldPositionOf(item);
                this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, itemPos.x, itemPos.y + 0.3, itemPos.z, 0.0, 0.02, 0.0);
            }
        }
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevel() {
        ContinuousFryerBlockEntity controller = this.getControllerBE();
        if (controller == null || controller.level == null) {
            return BlazeBurnerBlock.HeatLevel.NONE;
        }
        Level level = controller.level;
        BlazeBurnerBlock.HeatLevel strongest = BlazeBurnerBlock.HeatLevel.NONE;
        for (ContinuousFryerBlockEntity fryer : controller.getConnectedChain()) {
            BlockPos below = fryer.getBlockPos().below();
            BlazeBurnerBlock.HeatLevel local = ContinuousFryerBlockEntity.getHeatLevelAt(level, below);
            if (local.ordinal() <= strongest.ordinal()) continue;
            strongest = local;
        }
        return strongest;
    }

    private static BlazeBurnerBlock.HeatLevel getHeatLevelAt(Level level, BlockPos pos) {
        if (level == null) {
            return BlazeBurnerBlock.HeatLevel.NONE;
        }
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof BlazeBurnerBlock) {
            return (BlazeBurnerBlock.HeatLevel)state.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL);
        }
        return BlazeBurnerBlock.HeatLevel.NONE;
    }

    private boolean fluidNotSufficient() {
        return this.getFillState() < 0.95f;
    }

    private void tickFryingItems() {
        FryerInventory inventory = this.getItemInventory();
        if (inventory == null) {
            return;
        }
        List<FryingItemStack> items = inventory.getTransportedItems();
        if (items == null || items.isEmpty() || this.fluidNotSufficient()) {
            return;
        }
        for (FryingItemStack item : items) {
            FryingRecipe recipe;
            BlazeBurnerBlock.HeatLevel heatLevel = this.getHeatLevel();
            if (!(item.lastRecipe != null && item.lastRecipe.matches(item.stack, this.tankInventory.getFluid(), heatLevel) || (recipe = RFDRecipeTypes.findFryingRecipe(this.level, item.stack, this.tankInventory.getFluid(), heatLevel)) == null)) {
                if (item.lastRecipe != recipe) {
                    item.processingTime = 0;
                }
                item.lastRecipe = recipe;
            }
            if (item.lastRecipe != null || item.lastRecipe == null && !this.tankInventory.isEmpty() && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
                ++item.processingTime;
                if (item.processingTime % 5 == 0 && this.level != null && !this.level.isClientSide) {
                    this.level.playSound(null, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.BLOCKS, 1.0f, 0.9f + this.level.random.nextFloat() * 0.2f);
                }
            }
            if (item.lastRecipe == null) {
                if (item.processingTime <= this.overFryingTime || item.stack.is(RFDItems.FRIED_RESIDUE)) continue;
                item.processingTime = 0;
                item.stack = new ItemStack((ItemLike)RFDItems.FRIED_RESIDUE.get(), item.stack.getCount());
                this.notifyUpdate();
                continue;
            }
            if (item.processingTime < item.lastRecipe.getProcessingDuration()) continue;
            item.stack = (ItemStack)RecipeApplier.applyRecipeOn((Level)this.level, (ItemStack)item.stack, (Recipe)item.lastRecipe, (boolean)true).getFirst();
            SizedFluidIngredient ingredient = (SizedFluidIngredient)item.lastRecipe.getFluidIngredients().getFirst();
            int totalDrain = ingredient.amount() * item.stack.getCount();
            this.tankInventory.drain(totalDrain, IFluidHandler.FluidAction.EXECUTE);
            item.clearFryerProcessingData();
        }
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (this.controller != null) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        compound.putBoolean("IsController", this.isController());
        compound.putInt("Length", this.fryerLength);
        compound.putInt("Index", this.index);
        if (this.isController()) {
            compound.put("ItemInventory", (Tag)this.getItemInventory().write(registries));
            compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
        }
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.putBoolean("ForceFluidLevel", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevLength = this.fryerLength;
        this.controller = compound.getBoolean("IsController") ? this.worldPosition : NBTHelper.readBlockPos((CompoundTag)compound, (String)"Controller");
        this.fryerLength = compound.getInt("Length");
        this.index = compound.getInt("Index");
        if (this.isController()) {
            this.getItemInventory().read(compound.getCompound("ItemInventory"), registries, this.level);
            this.tankInventory.setCapacity(this.fryerLength * ContinuousFryerBlockEntity.getFryerCapacityMultiplier());
            this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (compound.contains("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevLength != this.fryerLength) {
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(ContinuousFryerBlockEntity.getFryerCapacityMultiplier() * this.fryerLength);
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.contains("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    public Direction getMovementFacing() {
        Direction.Axis axis = this.getFryerFacing().getAxis();
        return Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)(this.getFryerMovementSpeed() < 0.0f ^ axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
    }

    protected Vec3i getMovementDirection(boolean firstHalf, boolean ignoreHalves) {
        if (this.getSpeed() == 0.0f) {
            return BlockPos.ZERO;
        }
        BlockState blockState = this.getBlockState();
        Direction beltFacing = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Direction.Axis axis = beltFacing.getAxis();
        Direction movementFacing = Direction.get((Direction.AxisDirection)(axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)axis);
        if (this.getSpeed() < 0.0f) {
            movementFacing = movementFacing.getOpposite();
        }
        return movementFacing.getNormal();
    }

    public Vec3i getMovementDirection(boolean firstHalf) {
        return this.getMovementDirection(firstHalf, false);
    }

    public Vec3i getFryerChainDirection() {
        return this.getMovementDirection(true, true);
    }

    public float getFryerMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public float getDirectionAwareBeltMovementSpeed() {
        int offset = this.getFryerFacing().getAxisDirection().getStep();
        if (this.getFryerFacing().getAxis() == Direction.Axis.X) {
            offset *= -1;
        }
        return this.getFryerMovementSpeed() * (float)offset;
    }

    public boolean shouldRenderNormally() {
        if (this.level == null) {
            return this.isController();
        }
        BlockState state = this.getBlockState();
        return state != null && state.hasProperty(ContinuousFryerBlock.PART) && state.getValue(ContinuousFryerBlock.PART) != FryerPart.MIDDLE;
    }
}

