/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.continuousfryer;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.belt.transport.BeltTunnelInteractionHandler;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.forsteri.ratatouille.content.oven_fan.OvenFanBlock;
import org.jetbrains.annotations.NotNull;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.ContinuousFryerBlockEntity;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerHelper;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerInventory;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerMovementHandler;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryerPart;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingItemStackHandlerBehaviour;
import org.starfruit.ratatouillefrieddelights.entry.RFDBlockEntityTypes;
import org.starfruit.ratatouillefrieddelights.entry.RFDBlocks;
import org.starfruit.ratatouillefrieddelights.entry.RFDFluids;
import org.starfruit.ratatouillefrieddelights.entry.RFDItems;

public class ContinuousFryerBlock
extends HorizontalKineticBlock
implements IBE<ContinuousFryerBlockEntity> {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final Property<FryerPart> PART = EnumProperty.create((String)"part", FryerPart.class);
    public static final VoxelShape SINGLE_SHAPE = Shapes.join((VoxelShape)AllShapes.CASING_13PX.get(Direction.UP), (VoxelShape)Block.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);

    public ContinuousFryerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)FryerPart.SINGLE)));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return state.getValue(PART) != FryerPart.MIDDLE && face.getAxis() == this.getRotationAxis(state);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper placementHelper;
        if (!player.isShiftKeyDown() && (placementHelper = PlacementHelpers.get((int)placementHelperId)).matchesItem(stack)) {
            return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.isEmpty() && hand == InteractionHand.MAIN_HAND) {
            ContinuousFryerBlockEntity fryer = FryerHelper.getSegmentBE((LevelAccessor)level, pos);
            if (fryer == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            ContinuousFryerBlockEntity controller = fryer.getControllerBE();
            if (controller == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            FryerInventory inventory = controller.getItemInventory();
            if (inventory == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            boolean[] taken = new boolean[]{false};
            inventory.applyToEachWithin((float)fryer.index + 0.5f, 0.55f, transported -> {
                player.getInventory().placeItemBackInInventory(transported.stack);
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + level.random.nextFloat());
                taken[0] = true;
                return FryingItemStackHandlerBehaviour.FryingResult.removeItem();
            });
            if (taken[0]) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            IFluidHandler fluidHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, state, (BlockEntity)be, null);
            if (fluidHandler == null) {
                return;
            }
            ContinuousFryerBlockEntity controller = be.getControllerBE();
            if (controller == null) {
                return;
            }
            if (stack.is((Item)RFDItems.SUNFLOWER_SEED_OIL_BOTTLE.get())) {
                FluidStack oil = new FluidStack(((BaseFlowingFluid.Flowing)RFDFluids.SUNFLOWER_OIL.get()).getSource(), 125);
                int fillable = fluidHandler.fill(oil, IFluidHandler.FluidAction.SIMULATE);
                if (fillable < oil.getAmount()) {
                    return;
                }
                int filled = fluidHandler.fill(oil, IFluidHandler.FluidAction.EXECUTE);
                if (filled > 0) {
                    level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 0.6f, 1.0f);
                    if (!player.isCreative()) {
                        stack.shrink(1);
                        ItemStack emptyBottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                        if (!player.addItem(emptyBottle)) {
                            player.drop(emptyBottle, false);
                        }
                    }
                }
            } else if (stack.is(Items.GLASS_BOTTLE)) {
                FluidStack drainSimulated = fluidHandler.drain(125, IFluidHandler.FluidAction.SIMULATE);
                if (drainSimulated.isEmpty()) {
                    return;
                }
                if (!drainSimulated.getFluid().isSame((Fluid)RFDFluids.SUNFLOWER_OIL.get())) {
                    return;
                }
                FluidStack drained = fluidHandler.drain(125, IFluidHandler.FluidAction.EXECUTE);
                if (!drained.isEmpty()) {
                    if (!player.isCreative()) {
                        stack.shrink(1);
                        ItemStack bottle = new ItemStack((ItemLike)RFDItems.SUNFLOWER_SEED_OIL_BOTTLE.get());
                        if (!player.addItem(bottle)) {
                            player.drop(bottle, false);
                        }
                    }
                    level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            } else {
                boolean filled;
                FluidStack before = fluidHandler.getFluidInTank(0).copy();
                boolean emptied = FluidHelper.tryEmptyItemIntoBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)stack, (SmartBlockEntity)controller);
                boolean bl = filled = !emptied && FluidHelper.tryFillItemFromBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)stack, (SmartBlockEntity)controller);
                if (!emptied && !filled) {
                    return;
                }
                FluidStack after = fluidHandler.getFluidInTank(0);
                SoundEvent sound = emptied ? FluidHelper.getEmptySound((FluidStack)after) : FluidHelper.getFillSound((FluidStack)before);
                level.playSound(null, pos, sound, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        });
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART});
        super.createBlockStateDefinition(builder);
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.RAIL;
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, worldIn, pos, oldState, isMoving);
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (isMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, ContinuousFryerBlockEntity::updateConnectivity);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = super.onWrenched(state, context);
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), be -> {
            be.split(false);
            be.updateConnectivity();
        });
        return result;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        FryerPart part = (FryerPart)((Object)state.getValue(PART));
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        switch (part) {
            case SINGLE: {
                return SINGLE_SHAPE;
            }
            case MIDDLE: {
                switch (facing.getAxis()) {
                    case X: {
                        return Shapes.join((VoxelShape)SINGLE_SHAPE, (VoxelShape)Block.box((double)0.0, (double)11.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
                    }
                    case Z: {
                        return Shapes.join((VoxelShape)SINGLE_SHAPE, (VoxelShape)Block.box((double)2.0, (double)11.0, (double)0.0, (double)14.0, (double)13.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST);
                    }
                }
                break;
            }
            case END: {
                switch (facing) {
                    case NORTH: {
                        return Shapes.join((VoxelShape)SINGLE_SHAPE, (VoxelShape)Block.box((double)2.0, (double)11.0, (double)0.0, (double)14.0, (double)13.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
                    }
                    case SOUTH: {
                        return Shapes.join((VoxelShape)SINGLE_SHAPE, (VoxelShape)Block.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)13.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST);
                    }
                    case WEST: {
                        return Shapes.join((VoxelShape)SINGLE_SHAPE, (VoxelShape)Block.box((double)0.0, (double)11.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
                    }
                    case EAST: {
                        return Shapes.join((VoxelShape)SINGLE_SHAPE, (VoxelShape)Block.box((double)2.0, (double)11.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
                    }
                }
            }
        }
        return SINGLE_SHAPE;
    }

    public Class<ContinuousFryerBlockEntity> getBlockEntityClass() {
        return ContinuousFryerBlockEntity.class;
    }

    public BlockEntityType<? extends ContinuousFryerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)RFDBlockEntityTypes.CONTINUOUS_FRYER.get();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        AdvancementBehaviour.setPlacedBy((Level)level, (BlockPos)pos, (LivingEntity)placer);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getClockWise().getAxis();
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityAfterFallOn(worldIn, entityIn);
        BlockPos entityPosition = entityIn.blockPosition();
        BlockPos fryerPos = null;
        if (RFDBlocks.CONTINUOUS_FRYER.has(worldIn.getBlockState(entityPosition))) {
            fryerPos = entityPosition;
        } else if (RFDBlocks.CONTINUOUS_FRYER.has(worldIn.getBlockState(entityPosition.below()))) {
            fryerPos = entityPosition.below();
        }
        if (fryerPos == null) {
            return;
        }
        if (!(worldIn instanceof Level)) {
            return;
        }
        this.entityInside(worldIn.getBlockState(fryerPos), (Level)worldIn, fryerPos, entityIn);
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (player.isShiftKeyDown() && !AllItems.CARDBOARD_BOOTS.isIn(player.getItemBySlot(EquipmentSlot.FEET))) {
                return;
            }
            if (player.getAbilities().flying) {
                return;
            }
        }
        if (DivingBootsItem.isWornBy((Entity)entityIn)) {
            return;
        }
        ContinuousFryerBlockEntity fryer = FryerHelper.getSegmentBE((LevelAccessor)worldIn, pos);
        if (fryer == null) {
            return;
        }
        ItemStack asItem = ItemHelper.fromItemEntity((Entity)entityIn);
        if (!asItem.isEmpty()) {
            if (worldIn.isClientSide) {
                return;
            }
            if (entityIn.getDeltaMovement().y > 0.0) {
                return;
            }
            Vec3 targetLocation = VecHelper.getCenterOf((Vec3i)pos).add(0.0, 0.3125, 0.0);
            if (!PackageEntity.centerPackage((Entity)entityIn, (Vec3)targetLocation)) {
                return;
            }
            if (BeltTunnelInteractionHandler.getTunnelOnPosition((Level)worldIn, (BlockPos)pos) != null) {
                return;
            }
            this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
                IItemHandler handler = (IItemHandler)worldIn.getCapability(Capabilities.ItemHandler.BLOCK, pos, state, (BlockEntity)be, null);
                if (handler == null) {
                    return;
                }
                ItemStack remainder = handler.insertItem(0, asItem, false);
                if (remainder.isEmpty()) {
                    entityIn.discard();
                } else if (entityIn instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entityIn;
                    if (remainder.getCount() != itemEntity.getItem().getCount()) {
                        itemEntity.setItem(remainder);
                    }
                }
            });
            return;
        }
        ContinuousFryerBlockEntity controller = FryerHelper.getControllerBE((LevelAccessor)worldIn, pos);
        if (controller == null || controller.passengers == null) {
            return;
        }
        if (controller.passengers.containsKey(entityIn)) {
            FryerMovementHandler.FringEntityInfo info = controller.passengers.get(entityIn);
            if (info.getTicksSinceLastCollision() != 0 || pos.equals((Object)entityIn.blockPosition())) {
                info.refresh(pos, state);
            }
        } else {
            controller.passengers.put(entityIn, new FryerMovementHandler.FringEntityInfo(pos, state));
            entityIn.setOnGround(true);
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> RFDBlocks.CONTINUOUS_FRYER.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> RFDBlocks.CONTINUOUS_FRYER.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction.Axis axis = ((Direction)state.getValue(OvenFanBlock.HORIZONTAL_FACING)).getAxis();
            List directions = IPlacementHelper.orderedByDistance((BlockPos)pos, (Vec3)ray.getLocation(), dir -> dir.getAxis() == axis && world.getBlockState(pos.relative(dir)).canBeReplaced());
            return directions.isEmpty() ? PlacementOffset.fail() : PlacementOffset.success((Vec3i)pos.relative((Direction)directions.getFirst()), s -> (BlockState)s.setValue(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue(OvenFanBlock.HORIZONTAL_FACING))));
        }
    }
}

