/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.colafruit;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.starfruit.ratatouillefrieddelights.content.colafruit.ColaFruitBlock;
import org.starfruit.ratatouillefrieddelights.entry.RFDBlocks;

public class ColaFruitItem
extends Item {
    public ColaFruitItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos clicked = ctx.getClickedPos();
        Direction face = ctx.getClickedFace();
        BlockPos targetPos = null;
        BlockState clickedState = level.getBlockState(clicked);
        boolean isLeaf = clickedState.is((Block)RFDBlocks.COLA_LEAVES.get());
        if (isLeaf && face == Direction.DOWN) {
            targetPos = clicked.below();
        } else {
            BlockPos maybeLeafAbove;
            BlockPos blockPos = maybeLeafAbove = level.getBlockState(clicked).isAir() ? clicked.above() : null;
            if (maybeLeafAbove != null && level.getBlockState(maybeLeafAbove).is((Block)RFDBlocks.COLA_LEAVES.get())) {
                targetPos = clicked;
            }
        }
        if (targetPos == null) {
            return InteractionResult.PASS;
        }
        if (!level.getBlockState(targetPos).isAir()) {
            return InteractionResult.FAIL;
        }
        BlockState placeState = (BlockState)((ColaFruitBlock)((Object)RFDBlocks.COLA_FRUIT_BLOCK.get())).defaultBlockState().setValue((Property)ColaFruitBlock.AGE, (Comparable)Integer.valueOf(0));
        if (!placeState.canSurvive((LevelReader)level, targetPos)) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide) {
            level.setBlock(targetPos, placeState, 3);
            level.playSound(null, targetPos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 0.8f, 1.0f);
            if (!ctx.getPlayer().getAbilities().instabuild) {
                ctx.getItemInHand().shrink(1);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

