/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.content.burger;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.IItemDecorator;
import org.starfruit.ratatouillefrieddelights.content.burger.BurgerContents;
import org.starfruit.ratatouillefrieddelights.content.burger.BurgerRenderingProperties;
import org.starfruit.ratatouillefrieddelights.content.burger.SimpleBurgerRenderingProperties;
import org.starfruit.ratatouillefrieddelights.entry.RFDDataComponents;
import org.starfruit.ratatouillefrieddelights.entry.RFDItems;
import vectorwing.farmersdelight.common.registry.ModItems;

public class BurgerRenderer
extends CustomRenderedItemModelRenderer {
    public static final IItemDecorator DECORATOR = (guiGraphics, font, stack, xOffset, yOffset) -> {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)xOffset, (float)yOffset, 100.0f);
        if (!stack.has(RFDDataComponents.BURGER_CONTENTS)) {
            return false;
        }
        BurgerContents burgerContents = (BurgerContents)stack.getOrDefault(RFDDataComponents.BURGER_CONTENTS, (Object)new BurgerContents(List.of(new ItemStack((ItemLike)RFDItems.BOTTOM_BURGER_BUN.get()), new ItemStack((ItemLike)ModItems.BEEF_PATTY.get()), new ItemStack((ItemLike)ModItems.BEEF_PATTY.get()), new ItemStack((ItemLike)RFDItems.CHEESE_SLICE.get()), new ItemStack((ItemLike)RFDItems.SHREDDED_LETTUCE.get()), new ItemStack((ItemLike)RFDItems.TOMATO_INGREDIENT.get()), new ItemStack((ItemLike)RFDItems.TOP_BURGER_BUN.get()))));
        int totalHeight = burgerContents.items.stream().map(ingredient -> BurgerRenderingProperties.BURGER_RENDERING_PROPERTIES_MAP.getOrDefault(ingredient.getItem(), SimpleBurgerRenderingProperties.of(4, 3, () -> ingredient)).renderingHeight()).mapToInt(Integer::intValue).sum();
        totalHeight += 5;
        totalHeight = Math.max(totalHeight, 18);
        totalHeight = 18;
        poseStack.translate(-0.25, 0.0, 0.0);
        poseStack.scale(16.0f / (float)totalHeight, 16.0f / (float)totalHeight, 16.0f / (float)totalHeight);
        poseStack.translate((1.0f - 16.0f / (float)totalHeight) / 2.0f * (float)totalHeight, 1.0f, 0.0f);
        poseStack.pushPose();
        for (ItemStack burgerContent : burgerContents.items()) {
            BurgerRenderingProperties renderingProperties = BurgerRenderingProperties.BURGER_RENDERING_PROPERTIES_MAP.getOrDefault(burgerContent.getItem(), SimpleBurgerRenderingProperties.of(4, 3, () -> burgerContent));
            poseStack.pushPose();
            poseStack.translate(0.0, 1.0 * (double)renderingProperties.renderingPivot(), 0.0);
            guiGraphics.renderItem(renderingProperties.renderingItem().get(), 0, 0);
            poseStack.popPose();
            poseStack.translate(0.0, -1.0 * (double)renderingProperties.renderingHeight(), 0.0);
            poseStack.scale(1.0039062f, 1.0f, 1.002809f);
        }
        poseStack.popPose();
        poseStack.popPose();
        return false;
    };
    protected static final PartialModel COG = PartialModel.of((ResourceLocation)Create.asResource((String)"item/potato_cannon/cog"));

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (transformType == ItemDisplayContext.GUI) {
            return;
        }
        if (!stack.has(RFDDataComponents.BURGER_CONTENTS)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        BurgerContents burgerContents = (BurgerContents)stack.getOrDefault(RFDDataComponents.BURGER_CONTENTS, (Object)new BurgerContents(List.of(new ItemStack((ItemLike)RFDItems.BOTTOM_BURGER_BUN.get()), new ItemStack((ItemLike)ModItems.BEEF_PATTY.get()), new ItemStack((ItemLike)ModItems.BEEF_PATTY.get()), new ItemStack((ItemLike)RFDItems.CHEESE_SLICE.get()), new ItemStack((ItemLike)RFDItems.SHREDDED_LETTUCE.get()), new ItemStack((ItemLike)RFDItems.TOMATO_INGREDIENT.get()), new ItemStack((ItemLike)RFDItems.TOP_BURGER_BUN.get()))));
        ms.pushPose();
        ms.translate(0.0f, 0.0625f, 0.0f);
        ms.translate(0.0f, 0.1875f, 0.0f);
        if (transformType != ItemDisplayContext.FIXED) {
            ms.scale(0.5f, 0.5f, 0.5f);
        }
        if (player != null && player.getUseItemRemainingTicks() > 0) {
            ms.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        for (ItemStack burgerContent : burgerContents.items()) {
            BurgerRenderingProperties renderingProperties = BurgerRenderingProperties.BURGER_RENDERING_PROPERTIES_MAP.getOrDefault(burgerContent.getItem(), SimpleBurgerRenderingProperties.of(4, 3, () -> burgerContent));
            ms.pushPose();
            ms.translate(0.0, -0.0625 * (double)renderingProperties.renderingPivot(), 0.0);
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            itemRenderer.renderStatic(renderingProperties.renderingItem().get(), ItemDisplayContext.FIXED, light, overlay, ms, buffer, null, 0);
            ms.popPose();
            ms.translate(0.0, 0.0625 * (double)renderingProperties.renderingHeight(), 0.0);
            ms.scale(1.0039062f, 1.0f, 1.0039062f);
        }
        ms.popPose();
    }
}

