/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.createmod.catnip.data.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.apache.commons.lang3.mutable.MutableInt;
import org.starfruit.ratatouillefrieddelights.compat.jei.category.animations.AnimatedContinuousFryer;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingRecipe;

public class FryingCategory
extends CreateRecipeCategory<FryingRecipe> {
    private final AnimatedContinuousFryer fryer = new AnimatedContinuousFryer();
    private static final int Y_OFFSET = -15;
    private static final int INPUT_Y_ADJUST = -10;

    public FryingCategory(CreateRecipeCategory.Info<FryingRecipe> info) {
        super(info);
    }

    protected void setRecipe(IRecipeLayoutBuilder builder, FryingRecipe recipe, IFocusGroup focuses) {
        HeatCondition requiredHeat;
        List results;
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.getIngredients());
        if (!condensedIngredients.isEmpty()) {
            Pair pair = (Pair)condensedIngredients.get(0);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)pair.getFirst()).getItems()) {
                ItemStack copy = itemStack.copy();
                copy.setCount(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 20, 10).setBackground(FryingCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
        }
        if (!recipe.getFluidIngredients().isEmpty()) {
            SizedFluidIngredient fluidIn = (SizedFluidIngredient)recipe.getFluidIngredients().get(0);
            FryingCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)20, (int)30, (SizedFluidIngredient)fluidIn);
        }
        if (!(results = recipe.getRollableResults()).isEmpty()) {
            ProcessingOutput output = (ProcessingOutput)results.get(0);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 140, 20).setBackground(FryingCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(FryingCategory.addStochasticTooltip((ProcessingOutput)output));
        }
        if (!(requiredHeat = recipe.getRequiredHeat()).testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 100, 37).addItemStack(AllBlocks.BLAZE_BURNER.asStack());
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 120, 37).addItemStack(AllItems.BLAZE_CAKE.asStack());
        }
    }

    protected void draw(FryingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        boolean noHeat;
        int blockX = 40;
        int blockY = 35;
        AllGuiTextures.JEI_ARROW.render(gui, 90, 23);
        AllGuiTextures.JEI_DOWN_ARROW.render(gui, blockX + 10, blockY - 32);
        PoseStack stack = gui.pose();
        stack.pushPose();
        stack.translate((float)(blockX - 8), (float)(blockY - 5), 0.0f);
        this.fryer.draw(gui, blockX - 18, blockY - 24);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        boolean bl = noHeat = requiredHeat == HeatCondition.NONE;
        if (noHeat) {
            return;
        }
        gui.drawString(Minecraft.getInstance().font, (Component)CreateLang.translateDirect((String)requiredHeat.getTranslationKey(), (Object[])new Object[0]), 100, 10, requiredHeat.getColor(), false);
    }
}

