/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.compat.jei;

import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.starfruit.ratatouillefrieddelights.RatatouilleFriedDelights;
import org.starfruit.ratatouillefrieddelights.compat.jei.category.CoatingCategory;
import org.starfruit.ratatouillefrieddelights.compat.jei.category.FryingCategory;
import org.starfruit.ratatouillefrieddelights.compat.jei.category.TumblingCategory;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingRecipe;
import org.starfruit.ratatouillefrieddelights.content.drumprocessor.CoatingRecipe;
import org.starfruit.ratatouillefrieddelights.content.drumprocessor.TumblingRecipe;
import org.starfruit.ratatouillefrieddelights.entry.RFDBlocks;
import org.starfruit.ratatouillefrieddelights.entry.RFDItems;
import org.starfruit.ratatouillefrieddelights.entry.RFDRecipeTypes;
import org.starfruit.ratatouillefrieddelights.util.Lang;

@ParametersAreNonnullByDefault
@JeiPlugin
public class RFDJei
implements IModPlugin {
    private static final ResourceLocation ID = RatatouilleFriedDelights.asResource("jei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    private IIngredientManager ingredientManager;

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.allCategories.clear();
        CreateRecipeCategory<CoatingRecipe> coating = this.builder(CoatingRecipe.class).addTypedRecipes(RFDRecipeTypes.COATING::getType).catalyst(() -> RFDBlocks.DRUM_PROCESSOR.get()).itemIcon((ItemLike)RFDBlocks.DRUM_PROCESSOR.get()).emptyBackground(177, 53).build("coating", (CreateRecipeCategory.Factory<CoatingRecipe>)((CreateRecipeCategory.Factory)CoatingCategory::new));
        CreateRecipeCategory<TumblingRecipe> tumbling = this.builder(TumblingRecipe.class).addTypedRecipes(RFDRecipeTypes.TUMBLING::getType).catalyst(() -> RFDBlocks.DRUM_PROCESSOR.get()).itemIcon((ItemLike)RFDBlocks.DRUM_PROCESSOR.get()).emptyBackground(177, 53).build("tumbling", (CreateRecipeCategory.Factory<TumblingRecipe>)((CreateRecipeCategory.Factory)TumblingCategory::new));
        CreateRecipeCategory<FryingRecipe> frying = this.builder(FryingRecipe.class).addTypedRecipes(RFDRecipeTypes.FRYING::getType).catalyst(() -> RFDBlocks.CONTINUOUS_FRYER.get()).itemIcon((ItemLike)RFDBlocks.CONTINUOUS_FRYER.get()).emptyBackground(160, 53).build("frying", (CreateRecipeCategory.Factory<FryingRecipe>)((CreateRecipeCategory.Factory)FryingCategory::new));
        this.allCategories.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)RFDItems.COLA_FRUITS.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Lang.translateDirect("jei.info.cola_fruits", new Object[0])});
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    private class CategoryBuilder<T extends Recipe<? extends RecipeInput>> {
        private final Class<? extends T> recipeClass;
        private final List<Consumer<List<RecipeHolder<T>>>> recipeListConsumers = new ArrayList<Consumer<List<RecipeHolder<T>>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public <I extends RecipeInput, R extends Recipe<I>> CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<R>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (this.recipeClass.isInstance(recipe.value())) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<RecipeHolder<T>>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).asItem()));
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : Collections::emptyList;
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(RatatouilleFriedDelights.asResource(name), this.recipeClass), (Component)Lang.translateDirect("recipe." + name, new Object[0]), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            RFDJei.this.allCategories.add(category);
            return category;
        }
    }
}

