/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.sandbox.facet.recorders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.internal.hppc.IntCursor;
import org.apache.lucene.ars_nouveau.internal.hppc.IntIntHashMap;
import org.apache.lucene.ars_nouveau.sandbox.facet.cutters.FacetCutter;
import org.apache.lucene.ars_nouveau.sandbox.facet.iterators.OrdinalIterator;
import org.apache.lucene.ars_nouveau.sandbox.facet.recorders.FacetRecorder;
import org.apache.lucene.ars_nouveau.sandbox.facet.recorders.LeafFacetRecorder;

public final class CountFacetRecorder
implements FacetRecorder {
    private IntIntHashMap values;
    private final List<IntIntHashMap> perLeafValues = Collections.synchronizedList(new ArrayList());

    public int getCount(int ord) {
        return this.values.get(ord);
    }

    @Override
    public LeafFacetRecorder getLeafRecorder(LeafReaderContext context) {
        IntIntHashMap leafValues = new IntIntHashMap();
        this.perLeafValues.add(leafValues);
        return new CountLeafFacetRecorder(leafValues);
    }

    @Override
    public OrdinalIterator recordedOrds() {
        final Iterator<IntCursor> ordIterator = this.values.keys().iterator();
        return new OrdinalIterator(){

            @Override
            public int nextOrd() {
                if (ordIterator.hasNext()) {
                    return ((IntCursor)ordIterator.next()).value;
                }
                return -1;
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public void reduce(FacetCutter facetCutter) throws IOException {
        OrdinalIterator dimOrds;
        boolean firstElement = true;
        for (IntIntHashMap leafRecords : this.perLeafValues) {
            if (firstElement) {
                this.values = leafRecords;
                firstElement = false;
                continue;
            }
            for (IntIntHashMap.IntIntCursor elem : leafRecords) {
                this.values.addTo(elem.key, elem.value);
            }
        }
        if (firstElement) {
            this.values = new IntIntHashMap();
        }
        if ((dimOrds = facetCutter.getOrdinalsToRollup()) != null) {
            int dimOrd = dimOrds.nextOrd();
            while (dimOrd != -1) {
                int rolledUp = this.rollup(dimOrd, facetCutter);
                if (rolledUp > 0) {
                    this.values.addTo(dimOrd, rolledUp);
                }
                dimOrd = dimOrds.nextOrd();
            }
        }
    }

    @Override
    public boolean contains(int ordinal) {
        return this.values.containsKey(ordinal);
    }

    private int rollup(int ord, FacetCutter facetCutter) throws IOException {
        OrdinalIterator childOrds = facetCutter.getChildrenOrds(ord);
        int accum = 0;
        int nextChild = childOrds.nextOrd();
        while (nextChild != -1) {
            int rolledUp = this.rollup(nextChild, facetCutter);
            accum = rolledUp > 0 ? (accum += this.values.addTo(nextChild, rolledUp)) : (accum += this.values.get(nextChild));
            nextChild = childOrds.nextOrd();
        }
        return accum;
    }

    private static class CountLeafFacetRecorder
    implements LeafFacetRecorder {
        private final IntIntHashMap values;

        public CountLeafFacetRecorder(IntIntHashMap values) {
            this.values = values;
        }

        @Override
        public void record(int docId, int facetOrd) {
            this.values.addTo(facetOrd, 1);
        }
    }
}

