/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.crafting.recipes.BuddingConversionRecipe;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;

public class BuddingConversionProvider
extends SimpleDataProvider {
    public List<Wrapper> recipes = new ArrayList<Wrapper>();

    public BuddingConversionProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (Wrapper recipe : this.recipes) {
            Path path = BuddingConversionProvider.getRecipePath(this.output, recipe.location().getPath());
            this.saveStable(pOutput, ANCodecs.toJson(BuddingConversionRecipe.CODEC, recipe.recipe), path);
        }
    }

    protected void addEntries() {
        this.recipes.add(new Wrapper(ArsNouveau.prefix("budding_amethyst"), new BuddingConversionRecipe(Blocks.AMETHYST_BLOCK, Blocks.BUDDING_AMETHYST)));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_nouveau/recipe/budding_conversion/" + id + ".json");
    }

    public String getName() {
        return "Budding Conversion Datagen";
    }

    public record Wrapper(ResourceLocation location, BuddingConversionRecipe recipe) {
    }
}

