/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IResolveListener;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.client.renderer.PlanariumRenderingWorld;
import com.hollingsworth.arsnouveau.client.renderer.world.CulledStatePos;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.mixin.structure.StructureTemplateAccessor;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketClientRequestDim;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateDimTile;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectName;
import com.hollingsworth.arsnouveau.common.world.dimension.PlanariumChunkGenerator;
import com.hollingsworth.arsnouveau.common.world.saved_data.DimMappingData;
import com.hollingsworth.arsnouveau.common.world.saved_data.JarDimData;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.nuggets.common.util.BlockPosHelpers;
import com.hollingsworth.nuggets.common.util.WorldHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.commoble.infiniverse.internal.DimensionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanariumTile
extends ModdedTile
implements ITickable,
Nameable {
    public static DimManager dimManager = new DimManager();
    public static Map<ResourceKey<Level>, ClientDimEntry> clientTemplates = new ConcurrentHashMap<ResourceKey<Level>, ClientDimEntry>();
    public ResourceKey<Level> key;
    public long lastUpdated = 0L;
    boolean playersNearby = true;
    public Component name;
    public boolean isDimModel = false;

    public PlanariumTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public PlanariumTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.PLANARIUM_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        if (this.key == null) {
            return;
        }
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.level.getGameTime() % 200L == 0L) {
                this.playersNearby = false;
                for (ServerPlayer serverPlayer : serverLevel.players()) {
                    if (!(BlockPosHelpers.distanceBetween((BlockPos)this.worldPosition, (BlockPos)serverPlayer.blockPosition()) < 64.0)) continue;
                    this.playersNearby = true;
                    break;
                }
            }
            if (!this.playersNearby) {
                return;
            }
            DimManager.Entry entry1 = dimManager.getOrCreateTemplate(serverLevel, this.worldPosition, this.key);
            if (entry1 != null && entry1.lastUpdated > this.lastUpdated) {
                this.lastUpdated = entry1.lastUpdated;
                StructureTemplate template = dimManager.getTemplate(this.key);
                if (template != null) {
                    Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new PacketUpdateDimTile(this.worldPosition, template));
                }
            }
        }
    }

    public void setTemplateClientSide(StructureTemplate template) {
        if (this.level.isClientSide && this.key != null) {
            ArrayList<CulledStatePos> statePos = new ArrayList<CulledStatePos>();
            StructureTemplate.Palette palette = ((StructureTemplateAccessor)template).getPalettes().get(0);
            for (StructureTemplate.StructureBlockInfo blockInfo : palette.blocks()) {
                statePos.add(new CulledStatePos(blockInfo.state(), blockInfo.pos(), blockInfo.nbt()));
            }
            clientTemplates.put(this.key, new ClientDimEntry(template, statePos, this.level.getGameTime(), new PlanariumRenderingWorld(this.level, statePos)));
            this.lastUpdated = this.level.getGameTime();
        }
    }

    public void onLoad() {
        super.onLoad();
        this.updateBlock();
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        if (this.level.isClientSide && this.key != null && (!clientTemplates.containsKey(this.key) || PlanariumTile.clientTemplates.get(this.key).lastUpdated < this.lastUpdated)) {
            Networking.sendToServer(new PacketClientRequestDim(this.worldPosition));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.key != null) {
            tag.putString("key", this.key.location().toString());
        }
        if (this.name != null) {
            tag.putString("name", this.name.getString());
        }
        tag.putLong("lastUpdated", this.lastUpdated);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("key")) {
            this.key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("key")));
        }
        if (tag.contains("name")) {
            this.name = Component.literal((String)tag.getString("name"));
        }
        this.lastUpdated = tag.getLong("lastUpdated");
    }

    @Nullable
    public StructureTemplate getTemplate() {
        if (this.key == null) {
            return null;
        }
        if (this.level.isClientSide) {
            ClientDimEntry entry = clientTemplates.get(this.key);
            return entry == null ? null : entry.template();
        }
        return dimManager.getTemplate(this.key);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        Level level;
        super.applyImplicitComponents(componentInput);
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
        if (this.name != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.setDimension(this.name.getString(), serverLevel);
        }
    }

    public void setName(Component name) {
        this.name = name;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (name == null) {
                this.key = null;
            } else {
                this.setDimension(name.getString(), serverLevel);
            }
        }
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public IResolveListener onResolve() {
        return new IResolveListener(){

            @Override
            public void onPostResolve(Level world, @NotNull LivingEntity shooter, HitResult result, Spell spell, SpellContext spellContext, AbstractEffect resolveEffect, SpellStats spellStats, SpellResolver spellResolver) {
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    if (resolveEffect instanceof EffectName && spell.name() != null) {
                        PlanariumTile.this.name = Component.literal((String)spell.name());
                        PlanariumTile.this.setDimension(spell.name(), serverLevel);
                    }
                }
            }
        };
    }

    public ServerLevel setDimension(String dimName, ServerLevel serverLevel) {
        Tuple<ServerLevel, DimManager.Entry> dimension = dimManager.getOrCreateLevel(dimName, serverLevel, this.worldPosition);
        DimMappingData.Entry dimData = DimMappingData.from(serverLevel).getOrCreateByName(dimName);
        this.key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimData.key());
        this.name = Component.literal((String)dimName);
        DimManager.Entry managerEntry = (DimManager.Entry)dimension.getB();
        if (managerEntry != null) {
            this.lastUpdated = managerEntry.lastUpdated;
            Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new PacketUpdateDimTile(this.worldPosition, managerEntry.template));
            this.updateBlock();
        }
        return (ServerLevel)dimension.getA();
    }

    public void sendEntityTo(Entity entity) {
        Level level;
        if (this.key != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerLevel dimLevel = this.level.getServer().getLevel(this.key);
            if (dimLevel == null) {
                return;
            }
            DimMappingData dimMappingData = DimMappingData.from(serverLevel);
            JarDimData jarData = JarDimData.from(dimLevel);
            if (entity instanceof ServerPlayer && dimMappingData.getByKey(this.level.dimension().location()) == null) {
                jarData.setEnteredFrom(entity.getUUID(), GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)entity.blockPosition()), entity.getRotationVector());
            }
            BlockPos spawnPos = jarData.getSpawnPos();
            entity.teleportTo(dimLevel, (double)spawnPos.getX() + 0.5, (double)(spawnPos.getY() + 1), (double)spawnPos.getZ() + 0.5, Set.of(), entity.getYRot(), entity.getXRot());
        }
    }

    public Component getName() {
        return this.name;
    }

    public static class DimManager {
        public Map<ResourceKey<Level>, Entry> entries = new ConcurrentHashMap<ResourceKey<Level>, Entry>();

        public static void onBlockBroken(BlockEvent.BreakEvent event) {
            ServerLevel level;
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel && WorldHelpers.isOfWorldType((Level)(level = (ServerLevel)levelAccessor), ArsNouveau.DIMENSION_TYPE_KEY)) {
                dimManager.markDirty((ResourceKey<Level>)level.dimension());
            }
        }

        public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
            ServerLevel level;
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel && WorldHelpers.isOfWorldType((Level)(level = (ServerLevel)levelAccessor), ArsNouveau.DIMENSION_TYPE_KEY)) {
                dimManager.markDirty((ResourceKey<Level>)level.dimension());
            }
        }

        public Tuple<ServerLevel, Entry> getOrCreateLevel(String dimName, ServerLevel serverLevel, BlockPos ownerPos) {
            DimMappingData.Entry dimEntry = DimMappingData.from(serverLevel.getServer().overworld()).getOrCreateByName(dimName);
            ResourceKey dimKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimEntry.key());
            return this.getOrCreateLevel(serverLevel, (ResourceKey<Level>)dimKey, ownerPos);
        }

        public Tuple<ServerLevel, Entry> getOrCreateLevel(ServerLevel serverLevel, ResourceKey<Level> key, BlockPos ownerPos) {
            ServerLevel newLevel = DimensionManager.INSTANCE.getOrCreateLevel(serverLevel.getServer(), key, () -> DimManager.createDimension(serverLevel.getServer()));
            Entry entry = this.getOrCreateTemplate(serverLevel, ownerPos, key);
            return new Tuple((Object)newLevel, (Object)entry);
        }

        public static LevelStem createDimension(MinecraftServer server) {
            return new LevelStem(DimManager.getDimensionTypeHolder(server), (ChunkGenerator)new PlanariumChunkGenerator(server));
        }

        public static Holder<DimensionType> getDimensionTypeHolder(MinecraftServer server) {
            return server.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE).getHolderOrThrow(ArsNouveau.DIMENSION_TYPE_KEY);
        }

        public StructureTemplate getTemplate(ResourceKey<Level> key) {
            Entry entry = this.entries.get(key);
            if (entry == null) {
                return null;
            }
            return entry.template;
        }

        public Entry getOrCreateTemplate(ServerLevel serverLevel, BlockPos worldPosition, ResourceKey<Level> key) {
            Entry entry = this.entries.get(key);
            if (entry == null) {
                StructureTemplate template = this.loadTemplate(serverLevel, worldPosition, key);
                if (template == null) {
                    return null;
                }
                this.entries.put(key, new Entry(template, false, serverLevel.getGameTime()));
                return this.entries.get(key);
            }
            if (!entry.dirty && entry.template != null) {
                return entry;
            }
            StructureTemplate template = this.loadTemplate(serverLevel, worldPosition, key);
            if (template == null) {
                return null;
            }
            this.entries.put(key, new Entry(template, false, serverLevel.getGameTime()));
            return this.entries.get(key);
        }

        private StructureTemplate loadTemplate(ServerLevel serverLevel, BlockPos worldPosition, ResourceKey<Level> key) {
            ServerLevel dimLevel = serverLevel.getServer().getLevel(key);
            if (dimLevel == null) {
                return null;
            }
            SectionPos chunkPos = SectionPos.of((BlockPos)BlockPos.ZERO);
            int chunkLoadingDistance = 3;
            this.forceLoad(chunkPos, chunkLoadingDistance, dimLevel, worldPosition, true);
            BlockPos pos = new BlockPos(0, 1, 0);
            Vec3i size = new Vec3i(32, 31, 32);
            StructureTemplate template = new StructureTemplate();
            template.fillFromWorld((Level)dimLevel, pos, size, true, Blocks.AIR);
            this.forceLoad(chunkPos, chunkLoadingDistance, dimLevel, worldPosition, false);
            return template;
        }

        private void forceLoad(SectionPos chunkPos, int chunkLoadingDistance, ServerLevel dimLevel, BlockPos worldPosition, boolean load) {
            for (int x = chunkPos.getX() - chunkLoadingDistance; x <= chunkPos.getX() + chunkLoadingDistance; ++x) {
                for (int z = chunkPos.getZ() - chunkLoadingDistance; z <= chunkPos.getZ() + chunkLoadingDistance; ++z) {
                    ArsNouveau.ticketController.forceChunk(dimLevel, worldPosition, x, z, load, false);
                }
            }
        }

        public void markDirty(ResourceKey<Level> key) {
            if (this.entries.containsKey(key)) {
                this.entries.put(key, new Entry(this.entries.get(key).template, true));
            }
        }

        public record Entry(StructureTemplate template, boolean dirty, long lastUpdated) {
            public Entry(StructureTemplate template, boolean dirty) {
                this(template, dirty, 0L);
            }
        }
    }

    public static class ClientDimEntry {
        private final StructureTemplate template;
        private List<CulledStatePos> statePosList;
        private final long lastUpdated;
        private final PlanariumRenderingWorld fakeRenderingWorld;
        private boolean needsCulled;

        public ClientDimEntry(StructureTemplate template, List<CulledStatePos> statePosList, long lastUpdated, PlanariumRenderingWorld fakeRenderingWorld) {
            this.template = template;
            this.statePosList = statePosList == null ? null : List.copyOf(statePosList);
            this.lastUpdated = lastUpdated;
            this.fakeRenderingWorld = fakeRenderingWorld;
            this.needsCulled = true;
        }

        public StructureTemplate template() {
            return this.template;
        }

        public List<CulledStatePos> statePosList() {
            return this.statePosList;
        }

        public long lastUpdated() {
            return this.lastUpdated;
        }

        public PlanariumRenderingWorld fakeRenderingWorld() {
            return this.fakeRenderingWorld;
        }

        public boolean needsCulled() {
            return this.needsCulled;
        }

        public void setCulledStates(List<CulledStatePos> culledStates) {
            this.needsCulled = false;
            this.statePosList = culledStates;
        }
    }
}

