/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.util;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapeRotator {
    public static VoxelShape cutout(VoxelShape ... cutouts) {
        VoxelShape shape = Shapes.block();
        for (VoxelShape cutout : cutouts) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)cutout, (BooleanOp)BooleanOp.ONLY_FIRST);
        }
        return shape.optimize();
    }

    public static VoxelShape rotateShapeHorizontal(VoxelShape shape, Direction from, Direction to) {
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public static VoxelShape flipShapeVertical(VoxelShape shape) {
        VoxelShape[] newShape = new VoxelShape[]{Shapes.empty()};
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            newShape[0] = Shapes.or((VoxelShape)newShape[0], (VoxelShape)Shapes.box((double)minX, (double)(1.0 - maxY), (double)minZ, (double)maxX, (double)(1.0 - minY), (double)maxZ));
        });
        return newShape[0];
    }
}

