/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry.util;

import architectspalette.content.blocks.NubBlock;
import architectspalette.content.blocks.VerticalSlabBlock;
import architectspalette.core.platform.Services;
import architectspalette.core.registry.APBlockProperties;
import architectspalette.core.registry.util.IBlockSetBase;
import architectspalette.core.registry.util.RegistryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class StoneBlockSet
implements Supplier<Block> {
    private final String material_name;
    private final List<Supplier<? extends Block>> parts;
    public TagKey<Block> miningTag = BlockTags.MINEABLE_WITH_PICKAXE;
    public TagKey<Block> miningLevel = null;
    public boolean hasStoneCuttingRecipes = true;
    private static final List<StoneBlockSet> instances = new LinkedList<StoneBlockSet>();

    public static void forAllSets(Consumer<StoneBlockSet> consumer) {
        instances.forEach(consumer);
    }

    public StoneBlockSet(Supplier<? extends Block> base_block) {
        this(base_block, SetGroup.TYPICAL);
    }

    public StoneBlockSet(Supplier<? extends Block> base_block, SetGroup group) {
        this(base_block, group.components);
    }

    public StoneBlockSet(Supplier<? extends Block> base_block, SetGroup group, SetComponent ... additionalParts) {
        this(base_block, StoneBlockSet.concatArray(group.components, additionalParts));
    }

    public StoneBlockSet(Supplier<? extends Block> base_block, SetComponent ... parts) {
        this.parts = new ArrayList<Supplier<? extends Block>>();
        for (int i = 0; i < SetComponent.values().length; ++i) {
            this.parts.add(null);
        }
        ResourceLocation base_block_id = Services.REGISTRY.getId(base_block);
        if (base_block_id == null) {
            throw new IllegalArgumentException("Base block must have a registry entry");
        }
        this.material_name = StoneBlockSet.getMaterialFromBlock(base_block_id.getPath());
        this.setPart(SetComponent.BLOCK, base_block);
        for (SetComponent part : parts) {
            this.createPart(part);
        }
        instances.add(this);
    }

    private static String getMaterialFromBlock(String block) {
        return block.replace("bricks", "brick").replace("_planks", "").replace("_block", "").replace("tiles", "tile").replace("boards", "board");
    }

    private static String getMaterialAggressive(String block) {
        return StoneBlockSet.getMaterialFromBlock(block).replace("_brick", "").replace("_tile", "").replace("chiseled_", "");
    }

    private BlockBehaviour.Properties properties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.getPart(SetComponent.BLOCK));
    }

    @Override
    public Block get() {
        return this.getPart(SetComponent.BLOCK);
    }

    private Stream<? extends Block> blockStream() {
        return this.parts.stream().filter(Objects::nonNull).map(Supplier::get);
    }

    private Stream<Supplier<? extends Block>> SupplierStream() {
        return this.parts.stream().filter(Objects::nonNull);
    }

    public void forEach(Consumer<? super Block> action) {
        this.blockStream().forEach(action);
    }

    public void forEachSupplier(Consumer<Supplier<? extends Block>> action) {
        this.SupplierStream().forEach(action);
    }

    public void forEachPart(BiConsumer<SetComponent, ? super Block> consumer) {
        for (int i = 0; i < this.parts.size(); ++i) {
            if (this.parts.get(i) == null) continue;
            consumer.accept(SetComponent.get(i), (Block)this.parts.get(i).get());
        }
    }

    public void registerFlammable(int encouragement, int flammability) {
        this.forEach(b -> APBlockProperties.registerFlammable(b, encouragement, flammability));
    }

    public StoneBlockSet woodify() {
        this.usesAxe();
        this.hasStoneCuttingRecipes = false;
        return this;
    }

    public StoneBlockSet usesAxe() {
        this.miningTag = BlockTags.MINEABLE_WITH_AXE;
        return this;
    }

    public StoneBlockSet needsStone() {
        this.miningLevel = BlockTags.NEEDS_STONE_TOOL;
        return this;
    }

    public StoneBlockSet needsIron() {
        this.miningLevel = BlockTags.NEEDS_IRON_TOOL;
        return this;
    }

    public StoneBlockSet needsDiamond() {
        this.miningLevel = BlockTags.NEEDS_DIAMOND_TOOL;
        return this;
    }

    public Block getPart(SetComponent part) {
        return this.parts.get(part.ordinal()).get();
    }

    public Supplier<? extends Block> getRegistryPart(SetComponent part) {
        return this.parts.get(part.ordinal());
    }

    private void setPart(SetComponent part, Supplier<? extends Block> block) {
        this.parts.add(part.ordinal(), block);
    }

    private void createPart(SetComponent part) {
        this.setPart(part, this.makePart(part));
    }

    public void withPart(SetComponent part, Consumer<Block> action) {
        Block block = this.getPart(part);
        if (block != null) {
            action.accept(block);
        }
    }

    private Supplier<Block> makePart(SetComponent part) {
        return RegistryUtils.createBlock(part.getName(this.material_name), () -> {
            Block block = this.getPart(SetComponent.BLOCK);
            if (block instanceof IBlockSetBase) {
                IBlockSetBase base = (IBlockSetBase)block;
                return base.getBlockForPart(part, this.properties(), block);
            }
            return StoneBlockSet.getBlockForPart(part, this.properties(), block);
        }, part.tab);
    }

    public static Block getBlockForPart(SetComponent part, BlockBehaviour.Properties properties, Block base) {
        return switch (part.ordinal()) {
            default -> throw new MatchException(null, null);
            case 4 -> new WallBlock(properties);
            case 1 -> new SlabBlock(properties);
            case 2 -> new VerticalSlabBlock(properties);
            case 3 -> new StairBlock(base.defaultBlockState(), properties);
            case 5 -> new FenceBlock(properties);
            case 6 -> new RotatedPillarBlock(properties);
            case 7 -> new NubBlock(properties);
            case 0 -> throw new IllegalStateException("Should not call makePart on BLOCK. Use setPart instead.");
        };
    }

    private static <T> T[] concatArray(T[] array1, T[] array2) {
        T[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static enum SetGroup {
        SLABS(SetComponent.SLAB, SetComponent.VERTICAL_SLAB),
        NO_WALLS(SetComponent.SLAB, SetComponent.VERTICAL_SLAB, SetComponent.STAIRS),
        NO_STAIRS(SetComponent.SLAB, SetComponent.VERTICAL_SLAB, SetComponent.WALL),
        TYPICAL(SetComponent.SLAB, SetComponent.VERTICAL_SLAB, SetComponent.STAIRS, SetComponent.WALL);

        public final SetComponent[] components;

        private SetGroup(SetComponent ... components) {
            this.components = components;
        }

        public void forEach(Consumer<SetComponent> action) {
            Arrays.stream(this.components).forEachOrdered(action);
        }
    }

    public static enum SetComponent {
        BLOCK("", RegistryUtils.BUILDING_BLOCKS),
        SLAB("_slab", RegistryUtils.BUILDING_BLOCKS),
        VERTICAL_SLAB("_vertical_slab", RegistryUtils.BUILDING_BLOCKS),
        STAIRS("_stairs", RegistryUtils.BUILDING_BLOCKS),
        WALL("_wall", RegistryUtils.BUILDING_BLOCKS),
        FENCE("_fence", RegistryUtils.BUILDING_BLOCKS),
        PILLAR(SetComponent::pillarName, RegistryUtils.BUILDING_BLOCKS),
        NUB("_nub", RegistryUtils.BUILDING_BLOCKS);

        public final ResourceKey<CreativeModeTab> tab;
        public final Function<String, String> nameGenerator;
        private static final SetComponent[] values;

        private SetComponent(String suffix, ResourceKey<CreativeModeTab> tab) {
            this((String material) -> SetComponent.addSuffix(material, suffix), tab);
        }

        private SetComponent(Function<String, String> nameGen, ResourceKey<CreativeModeTab> tab) {
            this.nameGenerator = nameGen;
            this.tab = tab;
        }

        public String getName(String material) {
            return this.nameGenerator.apply(material);
        }

        private static String addSuffix(String material, String suffix) {
            return material + suffix;
        }

        private static String pillarName(String material) {
            return StoneBlockSet.getMaterialAggressive(material) + "_pillar";
        }

        public static SetComponent get(int ordinal) {
            return values[ordinal];
        }

        static {
            values = SetComponent.values();
        }
    }
}

