/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry.util;

import architectspalette.content.blocks.NubBlock;
import architectspalette.core.platform.Services;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.util.BlockNode;
import architectspalette.core.util.KeyMaker;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class RegistryUtils {
    public static final ResourceKey<CreativeModeTab> INGREDIENTS_TAB = KeyMaker.vanillaTab("ingredients");
    public static final ResourceKey<CreativeModeTab> BUILDING_BLOCKS = KeyMaker.vanillaTab("building_blocks");
    public static final ResourceKey<CreativeModeTab> FUNCTIONAL_BLOCKS = KeyMaker.vanillaTab("functional_blocks");
    public static final ResourceKey<CreativeModeTab> REDSTONE_BLOCKS = KeyMaker.vanillaTab("redstone_blocks");
    public static final ResourceKey<CreativeModeTab> NATURAL_BLOCKS = KeyMaker.vanillaTab("natural_blocks");

    public static Item resourceItem() {
        return new Item(new Item.Properties());
    }

    public static Supplier<Item> createItem(String name) {
        return RegistryUtils.createItem(name, RegistryUtils::resourceItem);
    }

    public static Supplier<Item> createItem(String name, Supplier<Item> item) {
        return RegistryUtils.createItem(name, item, INGREDIENTS_TAB);
    }

    @SafeVarargs
    public static Supplier<Item> createItem(String name, Supplier<Item> item, ResourceKey<CreativeModeTab> ... tab) {
        return Services.REGISTRY.registerItem(name, item, tab);
    }

    public static <T extends Block> Supplier<T> createBlock(String name, Supplier<T> block) {
        return RegistryUtils.createBlock(name, block, BUILDING_BLOCKS);
    }

    @SafeVarargs
    public static <T extends Block> Supplier<T> createBlock(String name, Supplier<T> block, ResourceKey<CreativeModeTab> ... tab) {
        Supplier regBlock = Services.REGISTRY.registerBlock(name, block);
        RegistryUtils.createItem(name, () -> new BlockItem((Block)regBlock.get(), new Item.Properties()), tab);
        return regBlock;
    }

    public static Supplier<Block> createBlockNoItem(String name, Supplier<Block> block) {
        return Services.REGISTRY.registerBlock(name, block);
    }

    public static Supplier<Block> createPottedPlant(Supplier<Block> plant) {
        ResourceLocation id = Services.REGISTRY.getId(plant);
        if (id == null) {
            throw new IllegalStateException("Plant is not registered " + String.valueOf(plant.get()));
        }
        String name = id.getPath();
        return RegistryUtils.createBlockNoItem("potted_" + name, () -> new FlowerPotBlock((Block)plant.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_AZURE_BLUET)));
    }

    public static Supplier<Block> makeNub(String name, Block block_to_copy) {
        return RegistryUtils.createBlock(name, () -> new NubBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block_to_copy)));
    }

    public static Supplier<Block> makeNub(String name, Supplier<Block> block_to_copy) {
        return RegistryUtils.createBlock(name, () -> new NubBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block_to_copy.get()))));
    }

    public static Supplier<Block> makeCopperNub(String name, Block block_to_copy, WeatheringCopper.WeatherState weatheringstate) {
        return RegistryUtils.createBlock(name, () -> new NubBlock.CopperNubBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block_to_copy), weatheringstate));
    }

    public static BlockNode createBoardNode(String name, Supplier<? extends Block> supplier) {
        BlockNode node = new BlockNode.Builder().tool(BlockNode.Tool.AXE).base(RegistryUtils.createBlock(name, supplier)).commonVariants().flag(BlockNode.DataFlag.BOARDS).build();
        APBlocks.boards.add(node);
        return node;
    }

    public static BlockNode createOreBrickNode(String ore) {
        return new BlockNode.Builder().tool(BlockNode.Tool.PICK).base(RegistryUtils.createBlock(ore + "_ore_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)))).addPart(BlockNode.BlockType.CRACKED).addPart(BlockNode.BlockType.CHISELED).commonVariants().build();
    }
}

