/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry.util;

import architectspalette.content.blocks.NubBlock;
import architectspalette.content.blocks.VerticalSlabBlock;
import architectspalette.core.platform.Services;
import architectspalette.core.registry.util.IBlockSetBase;
import architectspalette.core.registry.util.RegistryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BlockNode
implements Supplier<Block>,
ItemLike {
    public final BlockNode parent;
    public ArrayList<BlockNode> children;
    public final Supplier<Block> block;
    public final Style style;
    public final BlockType type;
    public final Tool tool;
    private final int flags;
    public final int dataFlags;
    private static final List<BlockNode> instances = new LinkedList<BlockNode>();

    public static void forAllBaseNodes(Consumer<BlockNode> consumer) {
        instances.forEach(consumer);
    }

    protected BlockNode(BlockNode parent, Supplier<Block> block, BlockType type, Tool tool, Style style, int flags, String blockName, int dataFlags) {
        this.parent = parent;
        this.type = type == null ? BlockType.BASE : type;
        this.tool = tool;
        this.style = style == null ? Style.CUBE : style;
        this.block = block == null ? this.makeBlock(blockName) : block;
        this.flags = flags;
        this.dataFlags = dataFlags;
    }

    private void setChildren(ArrayList<BlockNode> children) {
        this.children = children;
    }

    public Supplier<Block> getObject() {
        return this.block;
    }

    @Override
    public Block get() {
        return this.block.get();
    }

    public Supplier<Block> getChild(BlockType ... types) {
        for (BlockNode node : this.children) {
            if (node.type != types[0]) continue;
            if (types.length == 1) {
                return node.getObject();
            }
            return node.getChild(Arrays.copyOfRange(types, 1, types.length));
        }
        return null;
    }

    public ResourceLocation getId() {
        return Services.REGISTRY.getId(this.block);
    }

    public String getName() {
        return this.getId().getPath();
    }

    public void forEach(Consumer<BlockNode> consumer) {
        consumer.accept(this);
        for (BlockNode node : this.children) {
            node.forEach(consumer);
        }
    }

    public ArrayList<BlockNode> getParents() {
        ArrayList<BlockNode> list = new ArrayList<BlockNode>();
        BlockNode last = this;
        while (last.parent != null) {
            list.add(last.parent);
            last = last.parent;
        }
        return list;
    }

    public Supplier<Block> getSibling(BlockType type) {
        if (this.parent != null) {
            return this.parent.getChild(type);
        }
        return null;
    }

    private BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.parent.block.get()));
    }

    private Supplier<Block> makeBlock(String blockName) {
        String name = blockName == null ? BlockNode.modifyBlockNameForType(this.type, this.parent.getName()) : blockName;
        return RegistryUtils.createBlock(name, () -> {
            Block block = this.parent.block.get();
            if (block instanceof IBlockSetBase) {
                IBlockSetBase base = (IBlockSetBase)block;
                return base.getBlockForType(this.type, this.getProperties(), block);
            }
            return BlockNode.getBlockForType(this.type, this.getProperties(), block);
        }, BlockNode.getTabForType(this.type));
    }

    public boolean getFlag(ExcludeFlag flag) {
        return (this.flags & flag.value) != 0;
    }

    public boolean getDataFlag(DataFlag flag) {
        return (this.dataFlags & flag.value()) != 0;
    }

    public Item asItem() {
        return this.get().asItem();
    }

    public static Block getBlockForType(BlockType part, BlockBehaviour.Properties properties, Block base) {
        return switch (part.ordinal()) {
            case 12 -> new WallBlock(properties);
            case 9 -> new SlabBlock(properties);
            case 10 -> new VerticalSlabBlock(properties);
            case 11 -> new StairBlock(base.defaultBlockState(), properties);
            case 13 -> new FenceBlock(properties);
            case 7 -> new RotatedPillarBlock(properties);
            case 8 -> new NubBlock(properties);
            case 0 -> throw new IllegalStateException("Should not call makeBlock on BASE");
            default -> new Block(properties);
        };
    }

    private static String modifyBlockNameForType(BlockType type, String baseName) {
        String material = BlockNode.getMaterialFromBlock(baseName);
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> baseName;
            case 1 -> material + "_bricks";
            case 2 -> "cracked_" + baseName;
            case 3 -> "mossy_" + baseName;
            case 4 -> material + "_tiles";
            case 5 -> "chiseled_" + baseName;
            case 7 -> BlockNode.getMaterialAggressive(baseName) + "_pillar";
            case 8 -> material + "_nub";
            case 9 -> material + "_slab";
            case 10 -> material + "_vertical_slab";
            case 11 -> material + "_stairs";
            case 12 -> material + "_wall";
            case 13 -> material + "_fence";
            case 14 -> material + "_lamp";
            case 15 -> material + "_plating";
            case 16 -> "dark_" + baseName;
            case 6 -> "polished_" + baseName;
            case 17 -> throw new IllegalStateException("SPECIAL block did not have name specified");
        };
    }

    private static ResourceKey<CreativeModeTab> getTabForType(BlockType type) {
        switch (type.ordinal()) {
            default: 
        }
        return RegistryUtils.BUILDING_BLOCKS;
    }

    private static String getMaterialFromBlock(String block) {
        return block.replace("bricks", "brick").replace("_planks", "").replace("_block", "").replace("tiles", "tile").replace("boards", "board");
    }

    private static String getMaterialAggressive(String block) {
        return BlockNode.getMaterialFromBlock(block).replace("_brick", "").replace("_tile", "").replace("chiseled_", "");
    }

    public static enum BlockType {
        BASE,
        BRICKS,
        CRACKED,
        MOSSY,
        TILES,
        CHISELED,
        POLISHED,
        PILLAR,
        NUB,
        SLAB,
        VERTICAL_SLAB,
        STAIRS,
        WALL,
        FENCE,
        LAMP,
        PLATING,
        DARK,
        SPECIAL;

    }

    public static enum Tool {
        PICK((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, null),
        STONE_PICK((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, (TagKey<Block>)BlockTags.NEEDS_STONE_TOOL),
        IRON_PICK((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, (TagKey<Block>)BlockTags.NEEDS_IRON_TOOL),
        DIAMOND_PICK((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, (TagKey<Block>)BlockTags.NEEDS_DIAMOND_TOOL),
        AXE((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE, null),
        HOE((TagKey<Block>)BlockTags.MINEABLE_WITH_HOE, null),
        SHOVEL((TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL, null);

        final TagKey<Block> toolTag;
        final TagKey<Block> miningTag;

        private Tool(TagKey<Block> toolTag, TagKey<Block> miningTag) {
            this.toolTag = toolTag;
            this.miningTag = miningTag;
        }

        public TagKey<Block> getToolTag() {
            return this.toolTag;
        }

        public TagKey<Block> getMiningTag() {
            return this.miningTag;
        }
    }

    public static enum Style {
        CUBE,
        TOP_SIDES,
        TOP_SIDE_BOTTOM;

    }

    public static enum ExcludeFlag {
        MODELS(1),
        LOOT(2),
        RECIPES(4),
        TAGS(8),
        LANG(16);

        final int value;

        private ExcludeFlag(int value) {
            this.value = value;
        }
    }

    public static enum DataFlag {
        BOARDS,
        SWAG;


        public int value() {
            return (int)Math.pow(2.0, this.ordinal());
        }
    }

    public static class Builder {
        protected Builder parent;
        private final ArrayList<Builder> children = new ArrayList();
        private Supplier<Block> block;
        private Style style;
        private final BlockType type;
        private Tool tool;
        private final DataFlagBuilder flags;
        private int excludedFrom = 0;
        private String name;

        protected Builder(Builder parent, BlockType type) {
            this.parent = parent;
            this.flags = parent != null ? parent.flags : new DataFlagBuilder();
            this.type = type;
        }

        public Builder() {
            this(null, BlockType.BASE);
        }

        public Builder(BlockType type) {
            this(null, type);
        }

        private void inherit() {
            if (this.parent != null) {
                this.style = this.style == null ? this.parent.style : this.style;
                this.tool = this.tool == null ? this.parent.tool : this.tool;
            }
        }

        public BlockNode build() {
            if (this.parent == null) {
                BlockNode built = this.build(null);
                instances.add(built);
                return built;
            }
            throw new IllegalStateException("#build() was called on a child builder. Don't do that.");
        }

        private BlockNode build(BlockNode parent) {
            this.inherit();
            BlockNode built = new BlockNode(parent, this.block, this.type, this.tool, this.style, this.excludedFrom, this.name, this.flags.getFlags());
            ArrayList<BlockNode> nodeChildren = new ArrayList<BlockNode>();
            for (Builder builder : this.children) {
                nodeChildren.add(builder.build(built));
            }
            built.setChildren(nodeChildren);
            return built;
        }

        private Builder addChild(BlockType type) {
            Builder child = new Builder(this, type);
            this.children.add(child);
            return child;
        }

        public Builder addPart(BlockType type, Consumer<Builder> builderCode) {
            Builder child = this.addChild(type);
            builderCode.accept(child);
            return this;
        }

        public Builder addPart(BlockType type) {
            this.addChild(type);
            return this;
        }

        public Builder withPart(BlockType type) {
            return this.addChild(type);
        }

        public Builder done() {
            return this.parent;
        }

        public Builder variants(BlockType ... types) {
            for (BlockType type : types) {
                this.addChild(type);
            }
            return this;
        }

        public Builder commonVariants() {
            this.slabs();
            return this.variants(BlockType.STAIRS, BlockType.WALL);
        }

        public Builder base(Supplier<Block> block) {
            this.block = block;
            if (this.name == null) {
                this.name = Services.REGISTRY.getId(block).getPath();
            }
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder tool(Tool tool) {
            this.tool = tool;
            return this;
        }

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public Builder flag(DataFlag flag) {
            this.flags.add(flag);
            return this;
        }

        public Builder exclude(ExcludeFlag ... flags) {
            for (ExcludeFlag f : flags) {
                this.excludedFrom |= f.value;
            }
            return this;
        }

        public Builder slabs() {
            this.addChild(BlockType.SLAB);
            this.addChild(BlockType.VERTICAL_SLAB);
            return this;
        }

        public Builder bricks(Consumer<Builder> brickCode) {
            Builder bricks = this.addChild(BlockType.BRICKS);
            bricks.style = Style.CUBE;
            brickCode.accept(bricks);
            return this;
        }

        public Builder tiles(Consumer<Builder> tileCode) {
            Builder bricks = this.addChild(BlockType.TILES);
            bricks.style = Style.CUBE;
            tileCode.accept(bricks);
            return this;
        }

        private Builder getBaseParent() {
            Builder p = this.parent;
            if (this.parent == null) {
                return this;
            }
            return p.getBaseParent();
        }

        private static class DataFlagBuilder {
            private int flags = 0;

            private DataFlagBuilder() {
            }

            private void add(DataFlag flag) {
                this.flags |= flag.value();
            }

            public int getFlags() {
                return this.flags;
            }
        }
    }
}

