/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry;

import architectspalette.core.APConstants;
import architectspalette.core.platform.Services;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.level.block.SoundType;

public class APSounds {
    public static final Supplier<SoundEvent> BLOCK_ENTWINE_PLACE = APSounds.register("block.entwine.place");
    public static final Supplier<SoundEvent> BLOCK_ENTWINE_HIT = APSounds.register("block.entwine.hit");
    public static final Supplier<SoundEvent> ITEM_WARPS = APSounds.register("block.warping.item_warps");
    public static final Supplier<SoundEvent> CAGE_LANTERN_TOGGLE_ON = APSounds.register("block.cage_lantern.toggle_on");
    public static final Supplier<SoundEvent> CAGE_LANTERN_TOGGLE_OFF = APSounds.register("block.cage_lantern.toggle_off");
    public static final Supplier<SoundEvent> WIZARD_BLAST = APSounds.register("block.wizard_deflect");
    public static final Supplier<SoundEvent> HADALINE_ACTIVATE = APSounds.register("block.chiseled_hadaline.activate");

    public static void init() {
    }

    private static Supplier<SoundEvent> register(String key) {
        return Services.REGISTRY.registerSoundEvent(key, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)APConstants.rl(key)));
    }

    private static class LazySoundType
    extends SoundType {
        private final LazyLoadedValue<SoundEvent> breakSound;
        private final LazyLoadedValue<SoundEvent> stepSound;
        private final LazyLoadedValue<SoundEvent> placeSound;
        private final LazyLoadedValue<SoundEvent> hitSound;
        private final LazyLoadedValue<SoundEvent> fallSound;

        public LazySoundType(float volumeIn, float pitchIn, LazyLoadedValue<SoundEvent> breakSoundIn, LazyLoadedValue<SoundEvent> stepSoundIn, LazyLoadedValue<SoundEvent> placeSoundIn, LazyLoadedValue<SoundEvent> hitSoundIn, LazyLoadedValue<SoundEvent> fallSoundIn) {
            super(volumeIn, pitchIn, SoundEvents.STONE_BREAK, SoundEvents.STONE_STEP, SoundEvents.STONE_PLACE, SoundEvents.STONE_HIT, SoundEvents.STONE_FALL);
            this.breakSound = breakSoundIn;
            this.stepSound = stepSoundIn;
            this.placeSound = placeSoundIn;
            this.hitSound = hitSoundIn;
            this.fallSound = fallSoundIn;
        }

        public float getVolume() {
            return this.volume;
        }

        public float getPitch() {
            return this.pitch;
        }

        public SoundEvent getBreakSound() {
            return (SoundEvent)this.breakSound.get();
        }

        public SoundEvent getStepSound() {
            return (SoundEvent)this.stepSound.get();
        }

        public SoundEvent getPlaceSound() {
            return (SoundEvent)this.placeSound.get();
        }

        public SoundEvent getHitSound() {
            return (SoundEvent)this.hitSound.get();
        }

        public SoundEvent getFallSound() {
            return (SoundEvent)this.fallSound.get();
        }
    }

    public static class APSoundTypes {
        public static final SoundType ENTWINE = new LazySoundType(1.0f, 1.0f, (LazyLoadedValue<SoundEvent>)new LazyLoadedValue(() -> SoundEvents.DEEPSLATE_TILES_BREAK), (LazyLoadedValue<SoundEvent>)new LazyLoadedValue(() -> SoundEvents.GLASS_STEP), (LazyLoadedValue<SoundEvent>)new LazyLoadedValue(BLOCK_ENTWINE_PLACE), (LazyLoadedValue<SoundEvent>)new LazyLoadedValue(BLOCK_ENTWINE_HIT), (LazyLoadedValue<SoundEvent>)new LazyLoadedValue(() -> SoundEvents.GLASS_FALL));
        public static final SoundType ENDER_PEARL = new SoundType(1.0f, 2.0f, SoundEvents.SHROOMLIGHT_BREAK, SoundEvents.SHROOMLIGHT_STEP, SoundEvents.SHROOMLIGHT_PLACE, SoundEvents.SHROOMLIGHT_HIT, SoundEvents.SHROOMLIGHT_FALL);
    }
}

