/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry;

import architectspalette.content.blocks.BigBrickBlock;
import architectspalette.content.blocks.BreadBlock;
import architectspalette.content.blocks.CageLanternBlock;
import architectspalette.content.blocks.CustomTorchBlock;
import architectspalette.content.blocks.CustomWallTorchBlock;
import architectspalette.content.blocks.GlassLikePillarBlock;
import architectspalette.content.blocks.GreenFireBlock;
import architectspalette.content.blocks.PipeBlock;
import architectspalette.content.blocks.RailingBlock;
import architectspalette.content.blocks.SmallSignBlock;
import architectspalette.content.blocks.StrippablePilarBlock;
import architectspalette.content.blocks.SunstoneBlock;
import architectspalette.content.blocks.TotemBlock;
import architectspalette.content.blocks.TotemWingBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineLampBlock;
import architectspalette.content.blocks.abyssaline.AbyssalinePillarBlock;
import architectspalette.content.blocks.abyssaline.ChiseledAbyssalineBlock;
import architectspalette.content.blocks.entrails.DrippyBlock;
import architectspalette.content.blocks.flint.FlintBlock;
import architectspalette.content.blocks.flint.FlintPillarBlock;
import architectspalette.content.blocks.util.DirectionalFacingBlock;
import architectspalette.content.worldgen.features.APTreeGrowers;
import architectspalette.core.registry.APBlockProperties;
import architectspalette.core.registry.ParticleRegistry;
import architectspalette.core.registry.util.BlockNode;
import architectspalette.core.registry.util.RegistryUtils;
import architectspalette.core.registry.util.StoneBlockSet;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;

public class APBlocks {
    public static final ArrayList<BlockNode> boards = new ArrayList();
    public static final Supplier<Block> ABYSSALINE = RegistryUtils.createBlock("abyssaline", () -> new AbyssalineBlock(APBlockProperties.ABYSSALINE));
    public static final StoneBlockSet ABYSSALINE_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("abyssaline_bricks", () -> new AbyssalineBlock(APBlockProperties.ABYSSALINE)), StoneBlockSet.SetGroup.SLABS);
    public static final StoneBlockSet ABYSSALINE_TILES = new StoneBlockSet(RegistryUtils.createBlock("abyssaline_tiles", () -> new AbyssalineBlock(APBlockProperties.ABYSSALINE)), StoneBlockSet.SetGroup.SLABS);
    public static final Supplier<Block> CHISELED_ABYSSALINE_BRICKS = RegistryUtils.createBlock("chiseled_abyssaline_bricks", () -> new ChiseledAbyssalineBlock(APBlockProperties.CHISELED_ABYSSALINE));
    public static final Supplier<Block> ABYSSALINE_PILLAR = RegistryUtils.createBlock("abyssaline_pillar", () -> new AbyssalinePillarBlock(APBlockProperties.ABYSSALINE));
    public static final Supplier<Block> ABYSSALINE_LAMP_BLOCK = RegistryUtils.createBlock("abyssaline_lamp", () -> new AbyssalineLampBlock(APBlockProperties.ABYSSALINE_LAMP));
    public static final Supplier<AbyssalineBlock> ABYSSALINE_PLATING = RegistryUtils.createBlock("abyssaline_plating", () -> new AbyssalineBlock(APBlockProperties.ABYSSALINE));
    public static final Supplier<Block> HADALINE = RegistryUtils.createBlock("hadaline", () -> new AbyssalineBlock(APBlockProperties.ABYSSALINE));
    public static final StoneBlockSet HADALINE_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("hadaline_bricks", () -> new AbyssalineBlock(APBlockProperties.ABYSSALINE)), StoneBlockSet.SetGroup.SLABS);
    public static final StoneBlockSet HADALINE_TILES = new StoneBlockSet(RegistryUtils.createBlock("hadaline_tiles", () -> new AbyssalineBlock(APBlockProperties.ABYSSALINE)), StoneBlockSet.SetGroup.SLABS);
    public static final Supplier<ChiseledAbyssalineBlock> CHISELED_HADALINE_BRICKS = RegistryUtils.createBlock("chiseled_hadaline_bricks", () -> new ChiseledAbyssalineBlock(APBlockProperties.CHISELED_ABYSSALINE));
    public static final Supplier<AbyssalinePillarBlock> HADALINE_PILLAR = RegistryUtils.createBlock("hadaline_pillar", () -> new AbyssalinePillarBlock(APBlockProperties.ABYSSALINE));
    public static final Supplier<AbyssalineLampBlock> HADALINE_LAMP_BLOCK = RegistryUtils.createBlock("hadaline_lamp", () -> new AbyssalineLampBlock(APBlockProperties.ABYSSALINE_LAMP));
    public static final Supplier<AbyssalineBlock> HADALINE_PLATING = RegistryUtils.createBlock("hadaline_plating", () -> new AbyssalineBlock(APBlockProperties.ABYSSALINE));
    public static final Supplier<Block> SALMON_LOG = RegistryUtils.createBlock("salmon_log", () -> new RotatedPillarBlock(APBlockProperties.Meat(MapColor.TERRACOTTA_RED)));
    public static final Supplier<Block> COD_LOG = RegistryUtils.createBlock("cod_log", () -> new RotatedPillarBlock(APBlockProperties.Meat(MapColor.TERRACOTTA_YELLOW)));
    public static final Supplier<Block> SALMON_SCALES = RegistryUtils.createBlock("salmon_scales", () -> new RotatedPillarBlock(APBlockProperties.Meat(MapColor.TERRACOTTA_RED)));
    public static final Supplier<Block> COD_SCALES = RegistryUtils.createBlock("cod_scales", () -> new RotatedPillarBlock(APBlockProperties.Meat(MapColor.TERRACOTTA_YELLOW)));
    public static final StoneBlockSet ENTRAILS = new StoneBlockSet(RegistryUtils.createBlock("entrails", () -> new DrippyBlock(APBlockProperties.Meat(MapColor.TERRACOTTA_PINK))), StoneBlockSet.SetGroup.NO_WALLS).usesAxe();
    public static final StoneBlockSet PLATING_BLOCK = new StoneBlockSet(RegistryUtils.createBlock("plating_block", () -> new Block(APBlockProperties.PLATING)), StoneBlockSet.SetGroup.TYPICAL, StoneBlockSet.SetComponent.NUB);
    public static final Supplier<Block> PIPE = RegistryUtils.createBlock("pipe", () -> new PipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)PLATING_BLOCK.get()).noOcclusion()));
    public static final Supplier<Block> SPOOL = RegistryUtils.createBlock("spool", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL)));
    public static final Supplier<Block> CHARCOAL_BLOCK = RegistryUtils.createBlockNoItem("charcoal_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COAL_BLOCK)));
    public static final StoneBlockSet MYONITE = new StoneBlockSet(RegistryUtils.createBlock("myonite", () -> new Block(APBlockProperties.MYONITE)));
    public static final StoneBlockSet MYONITE_BRICK = new StoneBlockSet(RegistryUtils.createBlock("myonite_bricks", () -> new Block(APBlockProperties.MYONITE)));
    public static final StoneBlockSet MUSHY_MYONITE_BRICK = new StoneBlockSet(RegistryUtils.createBlock("mushy_myonite_bricks", () -> new Block(APBlockProperties.MYONITE)));
    public static final StoneBlockSet OLIVESTONE_BRICK = new StoneBlockSet(RegistryUtils.createBlock("olivestone_bricks", () -> new Block(APBlockProperties.OLIVESTONE)));
    public static final StoneBlockSet OLIVESTONE_TILE = new StoneBlockSet(RegistryUtils.createBlock("olivestone_tiles", () -> new Block(APBlockProperties.OLIVESTONE)));
    public static final Supplier<Block> OLIVESTONE_PILLAR = RegistryUtils.createBlock("olivestone_pillar", () -> new RotatedPillarBlock(APBlockProperties.OLIVESTONE));
    public static final Supplier<Block> CRACKED_OLIVESTONE_BRICKS = RegistryUtils.createBlock("cracked_olivestone_bricks", () -> new Block(APBlockProperties.OLIVESTONE));
    public static final Supplier<Block> CRACKED_OLIVESTONE_TILES = RegistryUtils.createBlock("cracked_olivestone_tiles", () -> new Block(APBlockProperties.OLIVESTONE));
    public static final Supplier<Block> CHISELED_OLIVESTONE = RegistryUtils.createBlock("chiseled_olivestone", () -> new Block(APBlockProperties.OLIVESTONE));
    public static final Supplier<Block> ILLUMINATED_OLIVESTONE = RegistryUtils.createBlock("illuminated_olivestone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)OLIVESTONE_BRICK.get()).lightLevel(state -> 15)));
    public static final StoneBlockSet ALGAL_BRICK = new StoneBlockSet(RegistryUtils.createBlock("algal_bricks", () -> new Block(APBlockProperties.ALGAL_BRICK)));
    public static final Supplier<Block> CRACKED_ALGAL_BRICKS = RegistryUtils.createBlock("cracked_algal_bricks", () -> new Block(APBlockProperties.ALGAL_BRICK));
    public static final Supplier<Block> CHISELED_ALGAL_BRICKS = RegistryUtils.createBlock("chiseled_algal_bricks", () -> new Block(APBlockProperties.ALGAL_BRICK));
    public static final StoneBlockSet OVERGROWN_ALGAL_BRICK = new StoneBlockSet(RegistryUtils.createBlock("overgrown_algal_bricks", () -> new Block(APBlockProperties.ALGAL_BRICK)));
    public static final Supplier<Block> ALGAL_LAMP = RegistryUtils.createBlock("algal_lamp", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEA_LANTERN)));
    public static final BlockNode COAL_BRICKS = RegistryUtils.createOreBrickNode("coal");
    public static final BlockNode LAPIS_BRICKS = RegistryUtils.createOreBrickNode("lapis");
    public static final BlockNode REDSTONE_BRICKS = RegistryUtils.createOreBrickNode("redstone");
    public static final BlockNode IRON_BRICKS = RegistryUtils.createOreBrickNode("iron");
    public static final BlockNode GOLD_BRICKS = RegistryUtils.createOreBrickNode("gold");
    public static final BlockNode EMERALD_BRICKS = RegistryUtils.createOreBrickNode("emerald");
    public static final BlockNode DIAMOND_BRICKS = RegistryUtils.createOreBrickNode("diamond");
    public static final Supplier<Block> FLINT_BLOCK = RegistryUtils.createBlock("flint_block", () -> new FlintBlock(APBlockProperties.FLINT));
    public static final StoneBlockSet FLINT_TILES = new StoneBlockSet(RegistryUtils.createBlock("flint_tiles", () -> new FlintBlock(APBlockProperties.FLINT)));
    public static final Supplier<Block> FLINT_PILLAR = RegistryUtils.createBlock("flint_pillar", () -> new FlintPillarBlock(APBlockProperties.FLINT));
    public static final StoneBlockSet POLISHED_PACKED_ICE = new StoneBlockSet(RegistryUtils.createBlock("polished_packed_ice", () -> new Block(APBlockProperties.BUILDING_ICE)));
    public static final Supplier<Block> CHISELED_PACKED_ICE = RegistryUtils.createBlock("chiseled_packed_ice", () -> new Block(APBlockProperties.BUILDING_ICE));
    public static final Supplier<Block> PACKED_ICE_PILLAR = RegistryUtils.createBlock("packed_ice_pillar", () -> new RotatedPillarBlock(APBlockProperties.BUILDING_ICE));
    public static final StoneBlockSet SUNMETAL = new StoneBlockSet(RegistryUtils.createBlock("sunmetal_block", () -> new Block(APBlockProperties.SUNMETAL)), StoneBlockSet.SetGroup.NO_WALLS, StoneBlockSet.SetComponent.NUB);
    public static final Supplier<Block> CHISELED_SUNMETAL_BLOCK = RegistryUtils.createBlock("chiseled_sunmetal_block", () -> new Block(APBlockProperties.SUNMETAL));
    public static final Supplier<Block> SUNMETAL_PILLAR = RegistryUtils.createBlock("sunmetal_pillar", () -> new RotatedPillarBlock(APBlockProperties.SUNMETAL));
    public static final Supplier<Block> SUNMETAL_BARS = RegistryUtils.createBlock("sunmetal_bars", () -> new IronBarsBlock(APBlockProperties.SUNMETAL.noOcclusion()));
    public static final StoneBlockSet OSSEOUS_BRICK = new StoneBlockSet(RegistryUtils.createBlock("osseous_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BONE_BLOCK))));
    public static final Supplier<Block> OSSEOUS_PILLAR = RegistryUtils.createBlock("osseous_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BONE_BLOCK)));
    public static final Supplier<Block> OSSEOUS_SKULL = RegistryUtils.createBlock("osseous_skull", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BONE_BLOCK)));
    public static final Supplier<Block> LIT_OSSEOUS_SKULL = RegistryUtils.createBlock("lit_osseous_skull", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BONE_BLOCK).lightLevel(e -> 12)));
    public static final Supplier<Block> WITHERED_BONE_BLOCK = RegistryUtils.createBlock("withered_bone_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BONE_BLOCK)));
    public static final StoneBlockSet WITHERED_OSSEOUS_BRICK = new StoneBlockSet(RegistryUtils.createBlock("withered_osseous_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BONE_BLOCK))));
    public static final Supplier<Block> WITHERED_OSSEOUS_PILLAR = RegistryUtils.createBlock("withered_osseous_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BONE_BLOCK)));
    public static final Supplier<Block> WITHERED_OSSEOUS_SKULL = RegistryUtils.createBlock("withered_osseous_skull", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BONE_BLOCK)));
    public static final Supplier<Block> LIT_WITHERED_OSSEOUS_SKULL = RegistryUtils.createBlock("lit_withered_osseous_skull", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BONE_BLOCK).lightLevel(e -> 12)));
    public static final Supplier<Block> WITHER_LAMP = RegistryUtils.createBlock("wither_lamp", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEA_LANTERN)));
    public static final StoneBlockSet ENTWINE = new StoneBlockSet(RegistryUtils.createBlock("entwine_block", () -> new Block(APBlockProperties.ENTWINE)), StoneBlockSet.SetGroup.NO_WALLS);
    public static final Supplier<Block> ENTWINE_PILLAR = RegistryUtils.createBlock("entwine_pillar", () -> new RotatedPillarBlock(APBlockProperties.ENTWINE));
    public static final Supplier<Block> CHISELED_ENTWINE = RegistryUtils.createBlock("chiseled_entwine", () -> new Block(APBlockProperties.ENTWINE));
    public static final Supplier<Block> ENTWINE_BARS = RegistryUtils.createBlock("entwine_bars", () -> new IronBarsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ENTWINE.get()).noOcclusion()));
    public static final Supplier<Block> HEAVY_STONE_BRICKS = RegistryUtils.createBlock("heavy_stone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
    public static final Supplier<Block> HEAVY_MOSSY_STONE_BRICKS = RegistryUtils.createBlock("heavy_mossy_stone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSSY_STONE_BRICKS)));
    public static final Supplier<Block> HEAVY_CRACKED_STONE_BRICKS = RegistryUtils.createBlock("heavy_cracked_stone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRACKED_STONE_BRICKS)));
    public static final StoneBlockSet POLISHED_GLOWSTONE = new StoneBlockSet(RegistryUtils.createBlock("polished_glowstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOWSTONE))), StoneBlockSet.SetGroup.NO_STAIRS, StoneBlockSet.SetComponent.NUB);
    public static final Supplier<Block> RUNIC_GLOWSTONE = RegistryUtils.createBlock("runic_glowstone", () -> new DirectionalFacingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOWSTONE)));
    public static final Supplier<Block> SCUTE_BLOCK = RegistryUtils.createBlock("scute_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).strength(5.0f, 6.0f).sound(SoundType.BASALT).instrument(NoteBlockInstrument.BASEDRUM)));
    public static final Supplier<Block> ROTTEN_FLESH_BLOCK = RegistryUtils.createBlock("rotten_flesh_block", () -> new Block(APBlockProperties.Meat(MapColor.COLOR_ORANGE)));
    public static final StoneBlockSet GILDED_SANDSTONE = new StoneBlockSet(RegistryUtils.createBlock("gilded_sandstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE))), StoneBlockSet.SetGroup.NO_WALLS);
    public static final Supplier<Block> GILDED_SANDSTONE_PILLAR = RegistryUtils.createBlock("gilded_sandstone_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE)));
    public static final Supplier<Block> CHISELED_GILDED_SANDSTONE = RegistryUtils.createBlock("chiseled_gilded_sandstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE)));
    public static final Supplier<Block> WEEPING_BLACKSTONE = RegistryUtils.createBlock("weeping_blackstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE)));
    public static final Supplier<Block> TWISTING_BLACKSTONE = RegistryUtils.createBlock("twisting_blackstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE)));
    public static final Supplier<Block> WEEPING_BLACKSTONE_BRICKS = RegistryUtils.createBlock("weeping_blackstone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE_BRICKS)));
    public static final Supplier<Block> TWISTING_BLACKSTONE_BRICKS = RegistryUtils.createBlock("twisting_blackstone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE_BRICKS)));
    public static final Supplier<Block> CHORAL_END_STONE_BRICKS = RegistryUtils.createBlock("choral_end_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE_BRICKS)));
    public static final Supplier<Block> CRACKED_END_STONE_BRICKS = RegistryUtils.createBlock("cracked_end_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE_BRICKS)));
    public static final Supplier<Block> CHISELED_END_STONE_BRICKS = RegistryUtils.createBlock("chiseled_end_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE_BRICKS)));
    public static final StoneBlockSet WARPSTONE = new StoneBlockSet(RegistryUtils.createBlock("warpstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE))));
    public static final StoneBlockSet TWISTED_PLANKS = new StoneBlockSet(RegistryUtils.createBlock("twisted_planks", () -> new Block(APBlockProperties.TwistedWood())), StoneBlockSet.SetGroup.NO_WALLS).woodify();
    public static final Supplier<Block> STRIPPED_TWISTED_LOG = RegistryUtils.createBlock("stripped_twisted_log", () -> new RotatedPillarBlock(APBlockProperties.TwistedWood()));
    public static final Supplier<Block> STRIPPED_TWISTED_WOOD = RegistryUtils.createBlock("stripped_twisted_wood", () -> new RotatedPillarBlock(APBlockProperties.TwistedWood()));
    public static final Supplier<Block> TWISTED_LOG = RegistryUtils.createBlock("twisted_log", () -> new StrippablePilarBlock(APBlockProperties.TwistedWood(), STRIPPED_TWISTED_LOG.get()));
    public static final Supplier<Block> TWISTED_WOOD = RegistryUtils.createBlock("twisted_wood", () -> new StrippablePilarBlock(APBlockProperties.TwistedWood(), STRIPPED_TWISTED_WOOD.get()));
    public static final Supplier<Block> TWISTED_LEAVES = RegistryUtils.createBlock("twisted_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
    public static final Supplier<Block> TWISTED_FENCE = RegistryUtils.createBlock("twisted_fence", () -> new FenceBlock(APBlockProperties.TwistedWood()), RegistryUtils.BUILDING_BLOCKS);
    public static final Supplier<Block> TWISTED_FENCE_GATE = RegistryUtils.createBlock("twisted_fence_gate", () -> new FenceGateBlock(WoodType.OAK, APBlockProperties.TwistedWood()), RegistryUtils.BUILDING_BLOCKS, RegistryUtils.REDSTONE_BLOCKS);
    public static final Supplier<Block> TWISTED_DOOR = RegistryUtils.createBlock("twisted_door", () -> new DoorBlock(BlockSetType.OAK, APBlockProperties.TwistedWood().noOcclusion()), RegistryUtils.BUILDING_BLOCKS, RegistryUtils.REDSTONE_BLOCKS);
    public static final Supplier<Block> TWISTED_TRAPDOOR = RegistryUtils.createBlock("twisted_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, APBlockProperties.TwistedWood().noOcclusion()), RegistryUtils.BUILDING_BLOCKS, RegistryUtils.REDSTONE_BLOCKS);
    public static final Supplier<Block> TWISTED_BUTTON = RegistryUtils.createBlock("twisted_button", () -> new ButtonBlock(BlockSetType.OAK, 30, APBlockProperties.TwistedWood(true)), RegistryUtils.BUILDING_BLOCKS, RegistryUtils.REDSTONE_BLOCKS);
    public static final Supplier<Block> TWISTED_PRESSURE_PLATE = RegistryUtils.createBlock("twisted_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, APBlockProperties.TwistedWood(true)), RegistryUtils.BUILDING_BLOCKS, RegistryUtils.REDSTONE_BLOCKS);
    public static final Supplier<Block> TWISTED_SAPLING = RegistryUtils.createBlock("twisted_sapling", () -> new SaplingBlock(APTreeGrowers.WARPED_TREE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)), RegistryUtils.NATURAL_BLOCKS);
    public static final Supplier<Block> POTTED_TWISTED_SAPLING = RegistryUtils.createPottedPlant(TWISTED_SAPLING);
    public static final StoneBlockSet BASALT_TILES = new StoneBlockSet(RegistryUtils.createBlock("basalt_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BASALT))));
    public static final Supplier<Block> CRACKED_BASALT_TILES = RegistryUtils.createBlock("cracked_basalt_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BASALT)));
    public static final Supplier<Block> CHISELED_BASALT_TILES = RegistryUtils.createBlock("chiseled_basalt_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BASALT)));
    public static final Supplier<Block> SUNSTONE = RegistryUtils.createBlock("sunstone", () -> new SunstoneBlock(APBlockProperties.SUNSTONE, SunstoneBlock::sunstoneLight));
    public static final Supplier<Block> MOONSTONE = RegistryUtils.createBlock("moonstone", () -> new SunstoneBlock(APBlockProperties.SUNSTONE, SunstoneBlock::moonstoneLight));
    public static final Supplier<Block> MOLTEN_NETHER_BRICKS = RegistryUtils.createBlock("molten_nether_bricks", () -> new Block(APBlockProperties.MOLTEN_BRICK));
    public static final Supplier<Block> COARSE_SNOW = RegistryUtils.createBlock("coarse_snow", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SNOW_BLOCK)));
    public static final Supplier<Block> HEAVY_END_STONE_BRICKS = RegistryUtils.createBlock("heavy_end_stone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE_BRICKS), BigBrickBlock.BrickType.END_STONE));
    public static final Supplier<Block> HEAVY_CRACKED_END_STONE_BRICKS = RegistryUtils.createBlock("heavy_cracked_end_stone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE_BRICKS), BigBrickBlock.BrickType.END_STONE));
    public static final Supplier<Block> REDSTONE_CAGE_LANTERN = RegistryUtils.createBlock("redstone_cage_lantern", () -> new CageLanternBlock(APBlockProperties.CAGE_LANTERN, 3), RegistryUtils.FUNCTIONAL_BLOCKS, RegistryUtils.REDSTONE_BLOCKS);
    public static final Supplier<Block> GLOWSTONE_CAGE_LANTERN = RegistryUtils.createBlock("glowstone_cage_lantern", () -> new CageLanternBlock(APBlockProperties.CAGE_LANTERN, 3), RegistryUtils.FUNCTIONAL_BLOCKS, RegistryUtils.REDSTONE_BLOCKS);
    public static final Supplier<Block> ALGAL_CAGE_LANTERN = RegistryUtils.createBlock("algal_cage_lantern", () -> new CageLanternBlock(APBlockProperties.CAGE_LANTERN, 3), RegistryUtils.FUNCTIONAL_BLOCKS, RegistryUtils.REDSTONE_BLOCKS);
    public static final Supplier<TotemWingBlock> ACACIA_TOTEM_WING = RegistryUtils.createBlock("acacia_totem_wing", () -> new TotemWingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_PLANKS).noOcclusion().noLootTable().sound(SoundType.SCAFFOLDING).noCollission()));
    public static final Supplier<Block> GRINNING_ACACIA_TOTEM = RegistryUtils.createBlock("grinning_acacia_totem", () -> new TotemBlock(APBlockProperties.ACACIA_TOTEM, ACACIA_TOTEM_WING.get(), TotemBlock.TotemFace.GRINNING));
    public static final Supplier<Block> PLACID_ACACIA_TOTEM = RegistryUtils.createBlock("placid_acacia_totem", () -> new TotemBlock(APBlockProperties.ACACIA_TOTEM, ACACIA_TOTEM_WING.get(), TotemBlock.TotemFace.PLACID));
    public static final Supplier<Block> SHOCKED_ACACIA_TOTEM = RegistryUtils.createBlock("shocked_acacia_totem", () -> new TotemBlock(APBlockProperties.ACACIA_TOTEM, ACACIA_TOTEM_WING.get(), TotemBlock.TotemFace.SHOCKED));
    public static final Supplier<Block> BLANK_ACACIA_TOTEM = RegistryUtils.createBlock("blank_acacia_totem", () -> new TotemBlock(APBlockProperties.ACACIA_TOTEM, ACACIA_TOTEM_WING.get(), TotemBlock.TotemFace.BLANK));
    public static final Supplier<Block> ENDER_PEARL_BLOCK = RegistryUtils.createBlock("ender_pearl_block", () -> new Block(APBlockProperties.ENDER_PEARL));
    public static final BlockNode OAK_BOARDS = RegistryUtils.createBoardNode("oak_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final BlockNode BIRCH_BOARDS = RegistryUtils.createBoardNode("birch_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BIRCH_PLANKS)));
    public static final BlockNode SPRUCE_BOARDS = RegistryUtils.createBoardNode("spruce_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_PLANKS)));
    public static final BlockNode JUNGLE_BOARDS = RegistryUtils.createBoardNode("jungle_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_PLANKS)));
    public static final BlockNode DARK_OAK_BOARDS = RegistryUtils.createBoardNode("dark_oak_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_OAK_PLANKS)));
    public static final BlockNode ACACIA_BOARDS = RegistryUtils.createBoardNode("acacia_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_PLANKS)));
    public static final BlockNode MANGROVE_BOARDS = RegistryUtils.createBoardNode("mangrove_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MANGROVE_PLANKS)));
    public static final BlockNode CHERRY_BOARDS = RegistryUtils.createBoardNode("cherry_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_PLANKS)));
    public static final BlockNode BAMBOO_BOARDS = RegistryUtils.createBoardNode("bamboo_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final BlockNode CRIMSON_BOARDS = RegistryUtils.createBoardNode("crimson_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRIMSON_PLANKS)));
    public static final BlockNode WARPED_BOARDS = RegistryUtils.createBoardNode("warped_boards", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_PLANKS)));
    public static final BlockNode TWISTED_BOARDS = RegistryUtils.createBoardNode("twisted_boards", () -> new Block(APBlockProperties.TwistedWood()));
    public static final Supplier<Block> OAK_RAILING = RegistryUtils.createBlock("oak_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Supplier<Block> BIRCH_RAILING = RegistryUtils.createBlock("birch_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BIRCH_PLANKS)));
    public static final Supplier<Block> SPRUCE_RAILING = RegistryUtils.createBlock("spruce_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_PLANKS)));
    public static final Supplier<Block> JUNGLE_RAILING = RegistryUtils.createBlock("jungle_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_PLANKS)));
    public static final Supplier<Block> DARK_OAK_RAILING = RegistryUtils.createBlock("dark_oak_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_OAK_PLANKS)));
    public static final Supplier<Block> ACACIA_RAILING = RegistryUtils.createBlock("acacia_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_PLANKS)));
    public static final Supplier<Block> MANGROVE_RAILING = RegistryUtils.createBlock("mangrove_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MANGROVE_PLANKS)));
    public static final Supplier<Block> CHERRY_RAILING = RegistryUtils.createBlock("cherry_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_PLANKS)));
    public static final Supplier<Block> BAMBOO_RAILING = RegistryUtils.createBlock("bamboo_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final Supplier<Block> CRIMSON_RAILING = RegistryUtils.createBlock("crimson_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRIMSON_PLANKS)));
    public static final Supplier<Block> WARPED_RAILING = RegistryUtils.createBlock("warped_railing", () -> new RailingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_PLANKS)));
    public static final Supplier<Block> TWISTED_RAILING = RegistryUtils.createBlock("twisted_railing", () -> new RailingBlock(APBlockProperties.TwistedWood()));
    public static final StoneBlockSet DRIPSTONE_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("dripstone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DRIPSTONE_BLOCK))));
    public static final Supplier<Block> DRIPSTONE_PILLAR = RegistryUtils.createBlock("dripstone_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DRIPSTONE_BLOCK)));
    public static final Supplier<Block> CHISELED_DRIPSTONE = RegistryUtils.createBlock("chiseled_dripstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DRIPSTONE_BLOCK)));
    public static final Supplier<Block> HEAVY_DRIPSTONE_BRICKS = RegistryUtils.createBlock("heavy_dripstone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DRIPSTONE_BLOCK), BigBrickBlock.BrickType.DRIPSTONE));
    public static final Supplier<Block> DRIPSTONE_LAMP = RegistryUtils.createBlock("dripstone_lamp", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DRIPSTONE_BLOCK).lightLevel(e -> 8)));
    public static final StoneBlockSet CALCITE_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("calcite_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CALCITE))));
    public static final Supplier<Block> CALCITE_PILLAR = RegistryUtils.createBlock("calcite_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CALCITE)));
    public static final Supplier<Block> CHISELED_CALCITE = RegistryUtils.createBlock("chiseled_calcite", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CALCITE)));
    public static final Supplier<Block> HEAVY_CALCITE_BRICKS = RegistryUtils.createBlock("heavy_calcite_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CALCITE), BigBrickBlock.BrickType.CALCITE));
    public static final Supplier<Block> CALCITE_LAMP = RegistryUtils.createBlock("calcite_lamp", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CALCITE).lightLevel(e -> 8)));
    public static final StoneBlockSet TUFF_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("tuff_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TUFF))));
    public static final Supplier<Block> TUFF_PILLAR = RegistryUtils.createBlock("tuff_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TUFF)));
    public static final Supplier<Block> CHISELED_TUFF = RegistryUtils.createBlock("chiseled_tuff", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TUFF)));
    public static final Supplier<Block> HEAVY_TUFF_BRICKS = RegistryUtils.createBlock("heavy_tuff_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TUFF), BigBrickBlock.BrickType.TUFF));
    public static final Supplier<Block> TUFF_LAMP = RegistryUtils.createBlock("tuff_lamp", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TUFF).lightLevel(e -> 8)));
    public static final Supplier<Block> HELIODOR_ROD = RegistryUtils.createBlock("heliodor_rod", () -> new GlassLikePillarBlock(APBlockProperties.NETHER_CRYSTAL));
    public static final Supplier<Block> EKANITE_ROD = RegistryUtils.createBlock("ekanite_rod", () -> new GlassLikePillarBlock(APBlockProperties.NETHER_CRYSTAL));
    public static final Supplier<Block> MONAZITE_ROD = RegistryUtils.createBlock("monazite_rod", () -> new GlassLikePillarBlock(APBlockProperties.NETHER_CRYSTAL));
    public static final Supplier<Block> UNOBTANIUM_BLOCK = RegistryUtils.createBlock("unobtanium_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK)));
    public static final StoneBlockSet NETHER_BRASS = new StoneBlockSet(RegistryUtils.createBlock("nether_brass_block", () -> new Block(APBlockProperties.NETHER_BRASS)), StoneBlockSet.SetGroup.TYPICAL, StoneBlockSet.SetComponent.NUB);
    public static final StoneBlockSet CUT_NETHER_BRASS = new StoneBlockSet(RegistryUtils.createBlock("cut_nether_brass", () -> new Block(APBlockProperties.NETHER_BRASS)));
    public static final Supplier<Block> NETHER_BRASS_PILLAR = RegistryUtils.createBlock("nether_brass_pillar", () -> new RotatedPillarBlock(APBlockProperties.NETHER_BRASS));
    public static final StoneBlockSet SMOOTH_NETHER_BRASS = new StoneBlockSet(RegistryUtils.createBlock("smooth_nether_brass", () -> new Block(APBlockProperties.NETHER_BRASS)), StoneBlockSet.SetGroup.NO_WALLS);
    public static final Supplier<Block> NETHER_BRASS_FIRE = RegistryUtils.createBlockNoItem("nether_brass_fire", () -> new GreenFireBlock(APBlockProperties.GREEN_FIRE));
    public static final Supplier<Block> NETHER_BRASS_CHAIN = RegistryUtils.createBlock("nether_brass_chain", () -> new ChainBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)NETHER_BRASS.get()).sound(SoundType.CHAIN).noOcclusion().forceSolidOn()));
    public static final Supplier<Block> NETHER_BRASS_LANTERN = RegistryUtils.createBlock("nether_brass_lantern", () -> new LanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)NETHER_BRASS.get()).sound(SoundType.LANTERN).lightLevel(a -> 13)), RegistryUtils.BUILDING_BLOCKS, RegistryUtils.FUNCTIONAL_BLOCKS);
    public static final Supplier<Block> NETHER_BRASS_TORCH = RegistryUtils.createBlockNoItem("nether_brass_torch", () -> new CustomTorchBlock(APBlockProperties.BRASS_TORCH, ParticleRegistry.GREEN_FLAME));
    public static final Supplier<Block> NETHER_BRASS_WALL_TORCH = RegistryUtils.createBlockNoItem("nether_brass_wall_torch", () -> new CustomWallTorchBlock(APBlockProperties.BRASS_TORCH.dropsLike(NETHER_BRASS_TORCH.get()), ParticleRegistry.GREEN_FLAME));
    public static final StoneBlockSet ESOTERRACK = new StoneBlockSet(RegistryUtils.createBlock("esoterrack", () -> new Block(APBlockProperties.ESOTERRACK)));
    public static final StoneBlockSet ESOTERRACK_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("esoterrack_bricks", () -> new Block(APBlockProperties.ESOTERRACK)));
    public static final Supplier<Block> ESOTERRACK_PILLAR = RegistryUtils.createBlock("esoterrack_pillar", () -> new RotatedPillarBlock(APBlockProperties.ESOTERRACK));
    public static final StoneBlockSet ONYX = new StoneBlockSet(RegistryUtils.createBlock("onyx", () -> new Block(APBlockProperties.ONYX)));
    public static final StoneBlockSet ONYX_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("onyx_bricks", () -> new Block(APBlockProperties.ONYX)));
    public static final Supplier<Block> ONYX_PILLAR = RegistryUtils.createBlock("onyx_pillar", () -> new RotatedPillarBlock(APBlockProperties.ONYX));
    public static final StoneBlockSet WARDSTONE = new StoneBlockSet(RegistryUtils.createBlock("wardstone", () -> new Block(APBlockProperties.WARDSTONE)));
    public static final Supplier<Block> CHISELED_WARDSTONE = RegistryUtils.createBlock("chiseled_wardstone", () -> new Block(APBlockProperties.WARDSTONE));
    public static final StoneBlockSet WARDSTONE_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("wardstone_bricks", () -> new Block(APBlockProperties.WARDSTONE)));
    public static final Supplier<Block> WARDSTONE_PILLAR = RegistryUtils.createBlock("wardstone_pillar", () -> new RotatedPillarBlock(APBlockProperties.WARDSTONE));
    public static final Supplier<Block> WARDSTONE_LAMP = RegistryUtils.createBlock("wardstone_lamp", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)WARDSTONE.get()).lightLevel(state -> 14)));
    public static final StoneBlockSet ANCIENT_PLATING = new StoneBlockSet(RegistryUtils.createBlock("ancient_plating", () -> new Block(APBlockProperties.ANCIENT_PLATING)), StoneBlockSet.SetGroup.TYPICAL, StoneBlockSet.SetComponent.FENCE);
    public static final Supplier<Block> STONE_NUB = RegistryUtils.makeNub("stone_nub", Blocks.STONE);
    public static final Supplier<Block> SMOOTH_STONE_NUB = RegistryUtils.makeNub("smooth_stone_nub", Blocks.SMOOTH_STONE);
    public static final Supplier<Block> SANDSTONE_NUB = RegistryUtils.makeNub("sandstone_nub", Blocks.SANDSTONE);
    public static final Supplier<Block> ANDESITE_NUB = RegistryUtils.makeNub("andesite_nub", Blocks.ANDESITE);
    public static final Supplier<Block> GRANITE_NUB = RegistryUtils.makeNub("granite_nub", Blocks.GRANITE);
    public static final Supplier<Block> DIORITE_NUB = RegistryUtils.makeNub("diorite_nub", Blocks.DIORITE);
    public static final Supplier<Block> BLACKSTONE_NUB = RegistryUtils.makeNub("blackstone_nub", Blocks.BLACKSTONE);
    public static final Supplier<Block> DEEPSLATE_NUB = RegistryUtils.makeNub("deepslate_nub", Blocks.POLISHED_DEEPSLATE);
    public static final Supplier<Block> BONE_NUB = RegistryUtils.makeNub("bone_nub", Blocks.BONE_BLOCK);
    public static final Supplier<Block> NUB_OF_ENDER = RegistryUtils.makeNub("nub_of_ender", ENDER_PEARL_BLOCK);
    public static final Supplier<Block> IRON_NUB = RegistryUtils.makeNub("iron_nub", Blocks.IRON_BLOCK);
    public static final Supplier<Block> GOLD_NUB = RegistryUtils.makeNub("gold_nub", Blocks.GOLD_BLOCK);
    public static final Supplier<Block> DIAMOND_NUB = RegistryUtils.makeNub("diamond_nub", Blocks.DIAMOND_BLOCK);
    public static final Supplier<Block> EMERALD_NUB = RegistryUtils.makeNub("emerald_nub", Blocks.EMERALD_BLOCK);
    public static final Supplier<Block> NETHERITE_NUB = RegistryUtils.makeNub("netherite_nub", Blocks.NETHERITE_BLOCK);
    public static final Supplier<Block> COPPER_NUB = RegistryUtils.makeCopperNub("copper_nub", Blocks.COPPER_BLOCK, WeatheringCopper.WeatherState.UNAFFECTED);
    public static final Supplier<Block> WAXED_COPPER_NUB = RegistryUtils.makeCopperNub("waxed_copper_nub", Blocks.COPPER_BLOCK, WeatheringCopper.WeatherState.UNAFFECTED);
    public static final Supplier<Block> EXPOSED_COPPER_NUB = RegistryUtils.makeCopperNub("exposed_copper_nub", Blocks.EXPOSED_COPPER, WeatheringCopper.WeatherState.EXPOSED);
    public static final Supplier<Block> WAXED_EXPOSED_COPPER_NUB = RegistryUtils.makeCopperNub("waxed_exposed_copper_nub", Blocks.EXPOSED_COPPER, WeatheringCopper.WeatherState.EXPOSED);
    public static final Supplier<Block> WEATHERED_COPPER_NUB = RegistryUtils.makeCopperNub("weathered_copper_nub", Blocks.WEATHERED_COPPER, WeatheringCopper.WeatherState.WEATHERED);
    public static final Supplier<Block> WAXED_WEATHERED_COPPER_NUB = RegistryUtils.makeCopperNub("waxed_weathered_copper_nub", Blocks.WEATHERED_COPPER, WeatheringCopper.WeatherState.WEATHERED);
    public static final Supplier<Block> OXIDIZED_COPPER_NUB = RegistryUtils.makeCopperNub("oxidized_copper_nub", Blocks.OXIDIZED_COPPER, WeatheringCopper.WeatherState.OXIDIZED);
    public static final Supplier<Block> WAXED_OXIDIZED_COPPER_NUB = RegistryUtils.makeCopperNub("waxed_oxidized_copper_nub", Blocks.OXIDIZED_COPPER, WeatheringCopper.WeatherState.OXIDIZED);
    public static final Supplier<Block> HAZARD_SIGN = RegistryUtils.createBlock("hazard_sign", () -> new SmallSignBlock(APBlockProperties.PLATING), RegistryUtils.BUILDING_BLOCKS);
    public static final BlockNode TREAD_PLATE = new BlockNode.Builder().tool(BlockNode.Tool.IRON_PICK).style(BlockNode.Style.CUBE).base(RegistryUtils.createBlock("tread_plate", () -> new Block(APBlockProperties.PLATING))).slabs().variants(BlockNode.BlockType.STAIRS, BlockNode.BlockType.WALL).build();
    public static final BlockNode HAZARD_BLOCK = new BlockNode.Builder().tool(BlockNode.Tool.PICK).base(RegistryUtils.createBlock("hazard_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_CONCRETE)))).slabs().variants(BlockNode.BlockType.WALL).build();
    public static final BlockNode SHEET_METAL = new BlockNode.Builder().tool(BlockNode.Tool.PICK).base(RegistryUtils.createBlock("sheet_metal_block", () -> new Block(APBlockProperties.PLATING))).variants(BlockNode.BlockType.WALL).build();
    public static final BlockNode BREAD_BLOCK = new BlockNode.Builder().tool(BlockNode.Tool.AXE).exclude(BlockNode.ExcludeFlag.MODELS).base(RegistryUtils.createBlock("bread_block", () -> new BreadBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_WOOL)))).addPart(BlockNode.BlockType.SLAB, b -> b.exclude(BlockNode.ExcludeFlag.MODELS)).addPart(BlockNode.BlockType.NUB).addPart(BlockNode.BlockType.SPECIAL, b -> b.setName("crustless_bread_block")).build();
    public static final BlockNode ORACLE_BLOCK = new BlockNode.Builder().tool(BlockNode.Tool.PICK).base(RegistryUtils.createBlock("oracle_block", () -> new Block(APBlockProperties.ORACLE))).slabs().variants(BlockNode.BlockType.STAIRS, BlockNode.BlockType.PILLAR).bricks(b -> {
        b.commonVariants();
        b.addPart(BlockNode.BlockType.DARK, BlockNode.Builder::commonVariants);
    }).tiles(b -> {
        b.slabs();
        b.variants(BlockNode.BlockType.STAIRS, BlockNode.BlockType.WALL);
    }).addPart(BlockNode.BlockType.SPECIAL, b -> b.setName("framed_oracle_block")).addPart(BlockNode.BlockType.LAMP, b -> b.base(RegistryUtils.createBlock("oracle_lamp", () -> new Block(APBlockProperties.ORACLE_LAMP)))).build();
    public static final BlockNode CEREBRAL_BLOCK = new BlockNode.Builder().tool(BlockNode.Tool.PICK).base(RegistryUtils.createBlock("cerebral_block", () -> new Block(APBlockProperties.CEREBRAL))).slabs().variants(BlockNode.BlockType.STAIRS, BlockNode.BlockType.WALL, BlockNode.BlockType.PILLAR).tiles(b -> {
        b.exclude(BlockNode.ExcludeFlag.MODELS);
        b.commonVariants();
    }).build();
    public static final BlockNode MOONSHALE = new BlockNode.Builder().tool(BlockNode.Tool.PICK).base(RegistryUtils.createBlock("moonshale", () -> new Block(APBlockProperties.MOONSHALE))).commonVariants().variants(BlockNode.BlockType.CHISELED).bricks(b -> {
        b.commonVariants();
        b.addPart(BlockNode.BlockType.CRACKED);
        b.withPart(BlockNode.BlockType.CHISELED).setName("moonshale_flagstone");
    }).addPart(BlockNode.BlockType.SPECIAL, builder -> builder.setName("bordered_moonshale")).build();
    public static final BlockNode CRATERSTONE = new BlockNode.Builder().tool(BlockNode.Tool.PICK).base(RegistryUtils.createBlock("craterstone", () -> new Block(APBlockProperties.MOONSHALE))).commonVariants().build();
    public static final BlockNode NEBULITE = new BlockNode.Builder().tool(BlockNode.Tool.PICK).base(RegistryUtils.createBlock("nebulite", () -> new Block(APBlockProperties.NEBULITE))).commonVariants().addPart(BlockNode.BlockType.POLISHED, b -> {
        b.slabs();
        b.addPart(BlockNode.BlockType.STAIRS);
    }).build();

    public static void init() {
    }
}

