/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry;

import architectspalette.content.blocks.CageLanternBlock;
import architectspalette.content.blocks.SunstoneBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineHelper;
import architectspalette.content.blocks.abyssaline.AbyssalineLampBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineNubBlock;
import architectspalette.content.blocks.abyssaline.ChiseledAbyssalineBlock;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APSounds;
import architectspalette.core.registry.util.BlockNode;
import java.util.stream.Stream;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class APBlockProperties {
    public static final BlockBehaviour.Properties ABYSSALINE = APBlockProperties.AbyssalineBase();
    public static final BlockBehaviour.Properties ABYSSALINE_LAMP = APBlockProperties.AbyssalineBase().lightLevel(AbyssalineLampBlock::getLightValue).sound(SoundType.GLASS);
    public static final BlockBehaviour.Properties CHISELED_ABYSSALINE = APBlockProperties.AbyssalineBase().lightLevel(ChiseledAbyssalineBlock::getLightValue);
    public static final BlockBehaviour.Properties ABYSSALINE_NUB = APBlockProperties.AbyssalineBase().lightLevel(AbyssalineNubBlock::getLightValue);
    public static final BlockBehaviour.Properties FLINT = APBlockProperties.stoneBase().mapColor(MapColor.COLOR_GRAY).strength(3.0f, 16.0f).requiresCorrectToolForDrops();
    public static final BlockBehaviour.Properties MYONITE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE);
    public static final BlockBehaviour.Properties SUNMETAL = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(2.0f, 8.0f).sound(SoundType.NETHERITE_BLOCK).requiresCorrectToolForDrops();
    public static final BlockBehaviour.Properties BUILDING_ICE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_ICE).friction(0.8f);
    public static final BlockBehaviour.Properties OLIVESTONE = APBlockProperties.stoneBase().mapColor(MapColor.TERRACOTTA_GREEN).strength(1.5f, 6.0f).requiresCorrectToolForDrops();
    public static final BlockBehaviour.Properties ALGAL_BRICK = APBlockProperties.stoneBase().mapColor(MapColor.TERRACOTTA_CYAN).strength(2.0f, 6.0f).sound(SoundType.NETHER_BRICKS).requiresCorrectToolForDrops();
    public static final BlockBehaviour.Properties ENTWINE = APBlockProperties.stoneBase().mapColor(MapColor.COLOR_CYAN).strength(3.0f, 6.0f).sound(APSounds.APSoundTypes.ENTWINE).requiresCorrectToolForDrops();
    public static final BlockBehaviour.Properties ENDER_PEARL = APBlockProperties.stoneBase().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(APSounds.APSoundTypes.ENDER_PEARL);
    public static final BlockBehaviour.Properties PLATING = APBlockProperties.metalBase().mapColor(MapColor.STONE).strength(4.0f, 10.0f).sound(SoundType.NETHERITE_BLOCK).requiresCorrectToolForDrops();
    public static final BlockBehaviour.Properties NETHER_CRYSTAL = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).lightLevel(e -> 12).requiresCorrectToolForDrops().strength(1.2f);
    public static final BlockBehaviour.Properties NETHER_BRASS = APBlockProperties.metalBase().mapColor(MapColor.COLOR_YELLOW).strength(4.0f, 10.0f).sound(SoundType.COPPER).requiresCorrectToolForDrops();
    public static final BlockBehaviour.Properties ESOTERRACK = APBlockProperties.stoneBase().mapColor(MapColor.RAW_IRON).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NETHERRACK);
    public static final BlockBehaviour.Properties ONYX = APBlockProperties.stoneBase().mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.STONE);
    public static final BlockBehaviour.Properties WARDSTONE = APBlockProperties.stoneBase().mapColor(MapColor.COLOR_BLUE).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundType.NETHER_BRICKS);
    public static final BlockBehaviour.Properties MOONSHALE = APBlockProperties.stoneBase().mapColor(MapColor.TERRACOTTA_WHITE).requiresCorrectToolForDrops().strength(1.5f, 6.0f);
    public static final BlockBehaviour.Properties NEBULITE = APBlockProperties.stoneBase().mapColor(MapColor.COLOR_BLUE).requiresCorrectToolForDrops().strength(1.5f, 6.0f);
    public static final BlockBehaviour.Properties ANCIENT_PLATING = APBlockProperties.metalBase().mapColor(MapColor.COLOR_BROWN).requiresCorrectToolForDrops().strength(4.0f, 12.0f).sound(SoundType.NETHERITE_BLOCK);
    public static final BlockBehaviour.Properties GREEN_FIRE = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).noCollission().instabreak().lightLevel(p_50884_ -> 13).sound(SoundType.WOOL).noLootTable().pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties BRASS_TORCH = BlockBehaviour.Properties.of().noCollission().instabreak().lightLevel(p_50884_ -> 13).pushReaction(PushReaction.DESTROY).sound(SoundType.WOOD);
    public static final BlockBehaviour.Properties MOLTEN_BRICK = APBlockProperties.stoneBase().mapColor(MapColor.NETHER).requiresCorrectToolForDrops().strength(2.0f, 6.0f).lightLevel(state -> 3).hasPostProcess((a, b, c) -> true).emissiveRendering((a, b, c) -> true);
    public static final BlockBehaviour.Properties CAGE_LANTERN = BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().emissiveRendering((state, reader, pos) -> (Boolean)state.getValue((Property)CageLanternBlock.LIT)).hasPostProcess((state, reader, pos) -> (Boolean)state.getValue((Property)CageLanternBlock.LIT)).strength(3.5f).sound(SoundType.LANTERN).noOcclusion();
    public static final BlockBehaviour.Properties ACACIA_TOTEM = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD);
    public static final BlockBehaviour.Properties ORACLE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPUR_BLOCK).sound(SoundType.STONE);
    public static final BlockBehaviour.Properties ORACLE_LAMP = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPUR_BLOCK).sound(SoundType.STONE).lightLevel(state -> 15);
    public static final BlockBehaviour.Properties CEREBRAL = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE_BRICKS).sound(SoundType.DEEPSLATE_TILES);
    public static final BlockBehaviour.Properties SUNSTONE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BASALT).lightLevel(SunstoneBlock::lightValue);
    static final FireBlock fire = (FireBlock)Blocks.FIRE;

    private static BlockBehaviour.Properties AbyssalineBase() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OBSIDIAN).strength(25.0f, 600.0f).emissiveRendering(AbyssalineHelper::needsPostProcessing).hasPostProcess(AbyssalineHelper::needsPostProcessing).isValidSpawn(AbyssalineHelper::allowsMobSpawning).lightLevel(AbyssalineBlock::getLightValue);
    }

    public static BlockBehaviour.Properties Meat(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).strength(1.0f).sound(SoundType.CORAL_BLOCK);
    }

    private static BlockBehaviour.Properties stoneBase() {
        return BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.STONE);
    }

    private static BlockBehaviour.Properties metalBase() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.METAL);
    }

    private static BlockBehaviour.Properties woodBase() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD);
    }

    public static BlockBehaviour.Properties TwistedWood() {
        return APBlockProperties.woodBase().mapColor(MapColor.COLOR_PURPLE).strength(2.0f, 3.0f).sound(SoundType.WOOD);
    }

    public static BlockBehaviour.Properties TwistedWood(boolean redstoneComponent) {
        BlockBehaviour.Properties p = APBlockProperties.TwistedWood();
        if (redstoneComponent) {
            return p.noCollission().strength(0.5f);
        }
        return p;
    }

    public static void registerFlammables() {
        APBlockProperties.registerFlammable(APBlocks.TWISTED_FENCE.get(), 5, 20);
        APBlocks.TWISTED_PLANKS.registerFlammable(5, 20);
        Stream.of(APBlocks.GRINNING_ACACIA_TOTEM, APBlocks.PLACID_ACACIA_TOTEM, APBlocks.SHOCKED_ACACIA_TOTEM, APBlocks.BLANK_ACACIA_TOTEM, APBlocks.TWISTED_LOG, APBlocks.STRIPPED_TWISTED_LOG, APBlocks.TWISTED_WOOD, APBlocks.STRIPPED_TWISTED_WOOD, APBlocks.SPOOL, APBlocks.CHARCOAL_BLOCK, APBlocks.OAK_RAILING, APBlocks.BIRCH_RAILING, APBlocks.SPRUCE_RAILING, APBlocks.ACACIA_RAILING, APBlocks.DARK_OAK_RAILING, APBlocks.JUNGLE_RAILING, APBlocks.MANGROVE_RAILING, APBlocks.CHERRY_RAILING, APBlocks.BAMBOO_RAILING, APBlocks.TWISTED_RAILING).forEach(t -> APBlockProperties.registerFlammable((Block)t.get(), 5, 5));
        for (BlockNode node : APBlocks.boards) {
            node.forEach(n -> APBlockProperties.registerFlammable(n.get(), 5, 20));
        }
    }

    public static void registerFlammable(Block block, Integer encouragement, Integer flammability) {
        fire.setFlammable(block, encouragement.intValue(), flammability.intValue());
    }
}

