/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry;

import architectspalette.core.config.APConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class APBiomeModifiers {
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"architects_palette");
    public static DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<APUndergroundDecorationBiomeModifier>> UNDERGROUND_DECORATION_MODIFIER = BIOME_MODIFIER_SERIALIZER.register("underground_decoration", () -> APUndergroundDecorationBiomeModifier.CODEC);

    public record APUndergroundDecorationBiomeModifier(HolderSet<Biome> biomes, Holder<PlacedFeature> feature, GenerationStep.Decoration step) implements BiomeModifier
    {
        public static final MapCodec<APUndergroundDecorationBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(APUndergroundDecorationBiomeModifier::biomes), (App)PlacedFeature.CODEC.fieldOf("feature").forGetter(APUndergroundDecorationBiomeModifier::feature), (App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(APUndergroundDecorationBiomeModifier::step)).apply((Applicative)builder, APUndergroundDecorationBiomeModifier::new));

        public void modify(@NotNull Holder<Biome> biome, @NotNull BiomeModifier.Phase phase, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome) && APConfig.worldGenCheck(APConfig.NETHER_CRYSTAL_TOGGLE)) {
                builder.getGenerationSettings().addFeature(this.step, this.feature);
            }
        }

        @NotNull
        public MapCodec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }
}

