/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.platform.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import org.jetbrains.annotations.Nullable;

public interface IRegistryHelper {
    public static final Map<ResourceKey<CreativeModeTab>, ArrayList<Supplier<? extends Item>>> CREATIVE_TAB_ITEMS_MAP = new HashMap<ResourceKey<CreativeModeTab>, ArrayList<Supplier<? extends Item>>>();

    default public void addCreativeTabItems(@Nullable ResourceKey<CreativeModeTab> tab, Supplier<? extends Item> item) {
        if (tab == null) {
            return;
        }
        ArrayList<Supplier<? extends Item>> itemList = CREATIVE_TAB_ITEMS_MAP.get(tab);
        if (itemList == null) {
            CREATIVE_TAB_ITEMS_MAP.put(tab, new ArrayList<Supplier<? extends Item>>(List.of(item)));
        } else {
            itemList.add(item);
            CREATIVE_TAB_ITEMS_MAP.put(tab, itemList);
        }
    }

    public <T extends Item> Supplier<T> registerItem(String var1, Supplier<T> var2, ResourceKey<CreativeModeTab> ... var3);

    public <T extends Block> Supplier<T> registerBlock(String var1, Supplier<T> var2);

    public <T extends SoundEvent> Supplier<T> registerSoundEvent(String var1, Supplier<T> var2);

    public <T extends ParticleType<?>> Supplier<T> registerParticleType(String var1, Supplier<T> var2);

    public <T extends SimpleParticleType> Supplier<T> registerSimpleParticleType(String var1);

    public <T extends Feature<?>> Supplier<T> registerFeature(String var1, Supplier<T> var2);

    public <T extends RecipeSerializer<?>> Supplier<T> registerRecipeSerializer(String var1, Supplier<T> var2);

    public <T extends RecipeType<?>> Supplier<T> registerRecipeType(String var1, Supplier<T> var2);

    public <T extends CriterionTrigger<?>> Supplier<T> registerCriterion(String var1, Supplier<T> var2);

    public Supplier<CreativeModeTab> registerTab(String var1, Component var2, Supplier<ItemStack> var3, CreativeModeTab.DisplayItemsGenerator var4);

    public <T extends Block> void setRenderLayer(Supplier<T> var1, RenderType var2);

    @Nullable
    public <T extends Block> ResourceLocation getId(Supplier<T> var1);

    public List<? extends Block> getModBlocks();

    public List<? extends Item> getModItems();
}

