/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.platform;

import architectspalette.core.platform.services.IRegistryHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class NeoRegistryHelper
implements IRegistryHelper {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"architects_palette");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"architects_palette");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"architects_palette");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"architects_palette");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((Registry)BuiltInRegistries.FEATURE, (String)"architects_palette");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"architects_palette");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"architects_palette");
    public static final DeferredRegister<CriterionTrigger<?>> CRITERIA = DeferredRegister.create((Registry)BuiltInRegistries.TRIGGER_TYPES, (String)"architects_palette");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (String)"architects_palette");

    public static void register(IEventBus modEventBus) {
        SOUNDS.register(modEventBus);
        ITEMS.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
        BLOCKS.register(modEventBus);
        FEATURES.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        CRITERIA.register(modEventBus);
        TABS.register(modEventBus);
    }

    @Override
    @SafeVarargs
    public final <T extends Item> Supplier<T> registerItem(String name, Supplier<T> type, ResourceKey<CreativeModeTab> ... groups) {
        DeferredHolder item = ITEMS.register(name, type);
        if (groups != null) {
            for (ResourceKey<CreativeModeTab> tab : groups) {
                this.addCreativeTabItems(tab, (Supplier<? extends Item>)item);
            }
        }
        return item;
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(String name, Supplier<T> type) {
        return BLOCKS.register(name, type);
    }

    @Override
    public <T extends SoundEvent> Supplier<T> registerSoundEvent(String name, Supplier<T> type) {
        return SOUNDS.register(name, type);
    }

    @Override
    public <T extends ParticleType<?>> Supplier<T> registerParticleType(String name, Supplier<T> type) {
        return PARTICLE_TYPES.register(name, type);
    }

    @Override
    public <T extends SimpleParticleType> Supplier<T> registerSimpleParticleType(String name) {
        return this.registerParticleType(name, () -> new SimpleParticleType(false));
    }

    @Override
    public <T extends Feature<?>> Supplier<T> registerFeature(String name, Supplier<T> type) {
        return FEATURES.register(name, type);
    }

    @Override
    public <T extends RecipeSerializer<?>> Supplier<T> registerRecipeSerializer(String name, Supplier<T> type) {
        return RECIPE_SERIALIZERS.register(name, type);
    }

    @Override
    public <T extends RecipeType<?>> Supplier<T> registerRecipeType(String name, Supplier<T> type) {
        return RECIPE_TYPES.register(name, type);
    }

    @Override
    public <T extends CriterionTrigger<?>> Supplier<T> registerCriterion(String name, Supplier<T> type) {
        return CRITERIA.register(name, type);
    }

    @Override
    public Supplier<CreativeModeTab> registerTab(String id, Component name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator entries) {
        return TABS.register(id, () -> CreativeModeTab.builder().title(name).icon(icon).displayItems(entries).build());
    }

    @Override
    public <T extends Block> void setRenderLayer(Supplier<T> block, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)type);
    }

    @Override
    @Nullable
    public <T extends Block> ResourceLocation getId(Supplier<T> blockSupplier) {
        if (!(blockSupplier instanceof DeferredHolder)) {
            return null;
        }
        return ((DeferredHolder)blockSupplier).getId();
    }

    @Override
    public List<? extends Block> getModBlocks() {
        return BLOCKS.getEntries().stream().map(DeferredHolder::get).toList();
    }

    @Override
    public List<? extends Item> getModItems() {
        return ITEMS.getEntries().stream().map(DeferredHolder::get).toList();
    }
}

