/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.model.util;

import architectspalette.core.APConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class SpriteShift {
    private static final Map<String, SpriteShift> entries = new HashMap<String, SpriteShift>();
    private static Boolean areTexturesReady = false;
    protected ResourceLocation fromLocation;
    protected ResourceLocation toLocation;
    protected float uShift;
    protected float vShift;
    protected float vHeight;

    private SpriteShift(ResourceLocation from_block, ResourceLocation to_block) {
        this.fromLocation = from_block;
        this.toLocation = to_block;
        if (areTexturesReady.booleanValue()) {
            this.init();
        }
    }

    public static SpriteShift getShift(ResourceLocation from_block, ResourceLocation to_block) {
        String key = from_block.toString() + "->" + to_block.toString();
        if (entries.containsKey(key)) {
            return entries.get(key);
        }
        SpriteShift shift = new SpriteShift(from_block, to_block);
        entries.put(key, shift);
        return shift;
    }

    public static SpriteShift getShift(String from_block, String to_block) {
        return SpriteShift.getShift(APConstants.rl(from_block), APConstants.rl(to_block));
    }

    public static void onTexturesDoneStitching() {
        areTexturesReady = true;
        for (SpriteShift entry : entries.values()) {
            entry.init();
        }
    }

    private void init() {
        Function atlas = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        TextureAtlasSprite from = (TextureAtlasSprite)atlas.apply(this.fromLocation);
        TextureAtlasSprite to = (TextureAtlasSprite)atlas.apply(this.toLocation);
        this.uShift = to.getU0() - from.getU0();
        this.vShift = to.getV0() - from.getV0();
        this.vHeight = from.getV1() - from.getV0();
    }

    public float getUShift() {
        return this.uShift;
    }

    public float getVShift() {
        return this.vShift;
    }

    public float getVHeight() {
        return this.vHeight;
    }
}

