/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.model.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;

public class QuadHelper {
    public static final VertexFormat FORMAT = DefaultVertexFormat.BLOCK;
    public static final int VERTEX_STRIDE = FORMAT.getVertexSize() / 4;
    public static final int U_OFFSET = 4;
    public static final int V_OFFSET = 5;

    private QuadHelper() {
    }

    public static BakedQuad clone(BakedQuad quad) {
        return new BakedQuad(Arrays.copyOf(quad.getVertices(), quad.getVertices().length), quad.getTintIndex(), quad.getDirection(), quad.getSprite(), quad.isShade());
    }

    public static float getU(int[] vertexData, int vertex) {
        return Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 4]);
    }

    public static float getV(int[] vertexData, int vertex) {
        return Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 5]);
    }

    public static void setU(int[] vertexData, int vertex, float u) {
        vertexData[vertex * QuadHelper.VERTEX_STRIDE + 4] = Float.floatToRawIntBits(u);
    }

    public static void setV(int[] vertexData, int vertex, float v) {
        vertexData[vertex * QuadHelper.VERTEX_STRIDE + 5] = Float.floatToRawIntBits(v);
    }
}

