/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.model;

import architectspalette.core.model.SheetMetalHelper;
import architectspalette.core.model.util.BakedModelWrapperWithData;
import architectspalette.core.model.util.QuadHelper;
import architectspalette.core.model.util.SpriteShift;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SheetMetalModel
extends BakedModelWrapperWithData
implements SheetMetalHelper {
    private static final ModelProperty<SheetMetalHelper.SheetData> CT_PROPERTY = new ModelProperty();
    private final SpriteShift spriteShift;

    public SheetMetalModel(BakedModel originalModel, SpriteShift spriteShift) {
        super(originalModel);
        this.spriteShift = spriteShift;
    }

    @Override
    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state) {
        SheetMetalHelper.SheetData data = new SheetMetalHelper.SheetData();
        SheetMetalHelper.initializeData(world, pos, state, data);
        return builder.with(CT_PROPERTY, (Object)data);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData, renderType);
        if (!extraData.has(CT_PROPERTY)) {
            return quads;
        }
        SheetMetalHelper.SheetData data = (SheetMetalHelper.SheetData)extraData.get(CT_PROPERTY);
        if (data == null) {
            return quads;
        }
        quads = new ArrayList<BakedQuad>(quads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            Direction dir = quad.getDirection();
            int index = data.get(dir);
            if (index == -1) continue;
            BakedQuad newQuad = QuadHelper.clone(quad);
            int[] vertexData = newQuad.getVertices();
            float uShift = this.spriteShift.getUShift();
            float extraShift = this.spriteShift.getVHeight() * (float)index;
            float vShift = this.spriteShift.getVShift() + extraShift;
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = QuadHelper.getU(vertexData, vertex);
                float v = QuadHelper.getV(vertexData, vertex);
                QuadHelper.setU(vertexData, vertex, u + uShift);
                QuadHelper.setV(vertexData, vertex, v + vShift);
            }
            quads.set(i, newQuad);
        }
        return quads;
    }
}

