/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.model;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface SheetMetalHelper {
    public static void initializeData(BlockAndTintGetter world, BlockPos pos, BlockState state, SheetData data) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (Direction face : Direction.values()) {
            if (!Block.shouldRenderFace((BlockState)state, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)checkPos.setWithOffset((Vec3i)pos, face)) && !(state.getBlock() instanceof WallBlock)) continue;
            int index = 1;
            boolean doShift = false;
            if (world.getBlockState((BlockPos)checkPos.setWithOffset((Vec3i)pos, SheetMetalHelper.getUpDirection(face))).is(state.getBlock())) {
                ++index;
                doShift = true;
            }
            if (world.getBlockState((BlockPos)checkPos.setWithOffset((Vec3i)pos, SheetMetalHelper.getDownDirection(face))).is(state.getBlock())) {
                --index;
                doShift = true;
            }
            if (!doShift) continue;
            data.set(face, index);
        }
    }

    public static Direction getUpDirection(Direction face) {
        return switch (face) {
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
            default -> Direction.UP;
        };
    }

    public static Direction getDownDirection(Direction face) {
        return SheetMetalHelper.getUpDirection(face).getOpposite();
    }

    public static class SheetData {
        private final int[] indices = new int[6];

        public SheetData() {
            Arrays.fill(this.indices, -1);
        }

        public void set(Direction face, int index) {
            this.indices[face.get3DDataValue()] = index;
        }

        public int get(Direction face) {
            return this.indices[face.get3DDataValue()];
        }
    }
}

