/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.model;

import architectspalette.core.model.BoardHelper;
import architectspalette.core.model.util.BakedModelWrapperWithData;
import architectspalette.core.model.util.QuadHelper;
import architectspalette.core.model.util.SpriteShift;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BoardModel
extends BakedModelWrapperWithData
implements BoardHelper {
    private static final ModelProperty<BoardHelper.BoardData> BOARD_PROPERTY = new ModelProperty();
    private final SpriteShift spriteShift;

    public BoardModel(BakedModel originalModel, SpriteShift boardShift) {
        super(originalModel);
        this.spriteShift = boardShift;
    }

    @Override
    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state) {
        return builder.with(BOARD_PROPERTY, (Object)new BoardHelper.BoardData(pos));
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData, renderType);
        if (!extraData.has(BOARD_PROPERTY)) {
            return quads;
        }
        BoardHelper.BoardData data = (BoardHelper.BoardData)extraData.get(BOARD_PROPERTY);
        if (data == null) {
            return quads;
        }
        quads = new ArrayList<BakedQuad>(quads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            if (!BoardHelper.shouldShift(quad.getDirection(), data)) continue;
            BakedQuad newQuad = QuadHelper.clone(quad);
            int[] vertexData = newQuad.getVertices();
            float uShift = this.spriteShift.getUShift();
            float vShift = this.spriteShift.getVShift();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = QuadHelper.getU(vertexData, vertex);
                float v = QuadHelper.getV(vertexData, vertex);
                QuadHelper.setU(vertexData, vertex, u + uShift);
                QuadHelper.setV(vertexData, vertex, v + vShift);
            }
            quads.set(i, newQuad);
        }
        return quads;
    }
}

