/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.model;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public interface BoardHelper {
    public static boolean shouldShift(Direction dir, BoardData data) {
        boolean shift;
        int dirId = dir.get3DDataValue();
        if (dirId >= 2) {
            shift = data.getHorizontal();
            if (dirId < 4) {
                shift = !shift;
            }
        } else {
            shift = data.getVertical();
            if (dirId == 0) {
                shift = !shift;
            }
        }
        return shift;
    }

    public static class BoardData {
        private final boolean isXOdd;
        private final boolean isZOdd;

        public BoardData(BlockPos pos) {
            this.isXOdd = BoardData.isOdd(pos.getX());
            this.isZOdd = BoardData.isOdd(pos.getZ());
        }

        private static boolean isOdd(int num) {
            return num % 2 != 0;
        }

        public boolean getHorizontal() {
            return this.isZOdd ^ this.isXOdd;
        }

        public boolean getVertical() {
            return this.isXOdd;
        }
    }
}

