/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WitheredBoneLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<WitheredBoneLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> WitheredBoneLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("replaces").forGetter(m -> m.replacedItem), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("bone").forGetter(m -> m.boneItem))).apply((Applicative)inst, WitheredBoneLootModifier::new)));
    private final Item replacedItem;
    private final Item boneItem;

    protected WitheredBoneLootModifier(LootItemCondition[] conditionsIn, Item replacedItem, Item boneItem) {
        super(conditionsIn);
        this.replacedItem = replacedItem;
        this.boneItem = boneItem;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity t = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (t == null) {
            return generatedLoot;
        }
        if (t instanceof WitherSkeleton) {
            int amountOfBones = 0;
            for (ItemStack i2 : generatedLoot) {
                if (i2.getItem() != this.replacedItem) continue;
                amountOfBones += i2.getCount();
            }
            generatedLoot.removeIf(i -> i.getItem() == this.replacedItem);
            generatedLoot.add((Object)new ItemStack((ItemLike)this.boneItem, amountOfBones));
        }
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public static void register(IEventBus modBus) {
        DeferredRegister LOOT = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"architects_palette");
        LOOT.register("wither_skeleton_bones", CODEC);
        LOOT.register(modBus);
    }
}

