/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.integration;

import architectspalette.content.blocks.VerticalSlabBlock;
import architectspalette.core.APConstants;
import architectspalette.core.config.APConfig;
import architectspalette.core.platform.Services;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public abstract class VerticalSlabs {
    public static boolean quarkEnabled;
    public static boolean checkedQuark;
    public static String QUARK_ID;
    public static ResourceLocation VERTICAL_SLABS_CONDITION;

    public static boolean areVisible() {
        if (!checkedQuark) {
            quarkEnabled = Services.PLATFORM.isModLoaded(QUARK_ID);
            checkedQuark = true;
        }
        return (Boolean)APConfig.VERTICAL_SLABS_FORCED.get() != false || quarkEnabled;
    }

    public static JsonObject conditionObj() {
        JsonObject dummyObject = new JsonObject();
        dummyObject.addProperty("type", "quark:flag");
        dummyObject.addProperty("flag", "vertical_slabs");
        return dummyObject;
    }

    public static boolean isVisible(ItemLike item) {
        BlockItem block;
        Item item2 = item.asItem();
        if (item2 instanceof BlockItem && (block = (BlockItem)item2).getBlock() instanceof VerticalSlabBlock) {
            return VerticalSlabs.areVisible();
        }
        return true;
    }

    public static boolean isVisible(Supplier<? extends Item> item) {
        return VerticalSlabs.isVisible((ItemLike)item.get());
    }

    static {
        QUARK_ID = "quark";
        VERTICAL_SLABS_CONDITION = APConstants.rl("enable_vertical_slabs");
    }
}

