/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.integration;

import architectspalette.core.APConstants;
import architectspalette.core.config.APConfig;
import architectspalette.core.integration.VerticalSlabs;
import architectspalette.core.platform.Services;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class APVerticalSlabsCondition
implements ICondition {
    public static final APVerticalSlabsCondition INSTANCE = new APVerticalSlabsCondition();
    public static final MapCodec<APVerticalSlabsCondition> CODEC = MapCodec.unit((Object)INSTANCE).stable();

    public static void registerCondition(IEventBus modBus) {
        DeferredRegister CONDITION = DeferredRegister.create((Registry)NeoForgeRegistries.CONDITION_SERIALIZERS, (String)"architects_palette");
        CONDITION.register(VerticalSlabs.VERTICAL_SLABS_CONDITION.getPath(), () -> CODEC);
        CONDITION.register(modBus);
    }

    public boolean test(@NotNull ICondition.IContext context) {
        if (((Boolean)APConfig.VERTICAL_SLABS_FORCED.get()).booleanValue()) {
            return true;
        }
        if (Services.PLATFORM.isModLoaded(VerticalSlabs.QUARK_ID)) {
            MapCodec codec = (MapCodec)NeoForgeRegistries.CONDITION_SERIALIZERS.get(ResourceLocation.tryParse((String)"quark:flag"));
            if (codec == null) {
                return false;
            }
            DataResult optCondition = codec.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)VerticalSlabs.conditionObj());
            if (optCondition.isError()) {
                APConstants.LOGGER.error("Failed to parse Vertical Slabs condition: {}", (Object)optCondition.error());
                return false;
            }
            ((ICondition)((Pair)optCondition.getOrThrow()).getFirst()).test(context);
        }
        return false;
    }

    @NotNull
    public MapCodec<? extends APVerticalSlabsCondition> codec() {
        return CODEC;
    }
}

