/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.integration;

import architectspalette.core.config.APConfig;
import architectspalette.core.registry.APBlocks;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;

public class APTrades {
    public static final Map<VillagerProfession, Map<Integer, LinkedList<VillagerTrades.ItemListing>>> PROFESSION_MAP = new HashMap<VillagerProfession, Map<Integer, LinkedList<VillagerTrades.ItemListing>>>();
    public static final Map<Integer, LinkedList<VillagerTrades.ItemListing>> WONDERING_TRADES = new HashMap<Integer, LinkedList<VillagerTrades.ItemListing>>();

    private static void addTrade(VillagerProfession prof, Integer level, VillagerTrades.ItemListing trade) {
        PROFESSION_MAP.putIfAbsent(prof, new HashMap());
        PROFESSION_MAP.get(prof).putIfAbsent(level, new LinkedList());
        PROFESSION_MAP.get(prof).get(level).add(trade);
    }

    private static void addWondering(VillagerTrades.ItemListing trade) {
        APTrades.addWondering(1, trade);
    }

    private static void addWondering(Integer level, VillagerTrades.ItemListing trade) {
        WONDERING_TRADES.putIfAbsent(level, new LinkedList());
        WONDERING_TRADES.get(level).add(trade);
    }

    public static void registerTrades() {
        if (((Boolean)APConfig.VILLAGER_TRADES_ENABLED.get()).booleanValue()) {
            APTrades.addTrade(VillagerProfession.FISHERMAN, 2, (VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(APBlocks.COD_LOG.get(), 2, 8, 6, 4));
            APTrades.addTrade(VillagerProfession.FISHERMAN, 2, (VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(APBlocks.SALMON_LOG.get(), 4, 2, 8, 6));
            APTrades.addTrade(VillagerProfession.BUTCHER, 2, (VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(APBlocks.ENTRAILS.get().asItem(), 4, 1, 5, 5, 0.0f));
            APTrades.addTrade(VillagerProfession.ARMORER, 2, (VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(APBlocks.PLATING_BLOCK.get().asItem(), 4, 3, 12, 6, 0.1f));
            APTrades.addTrade(VillagerProfession.TOOLSMITH, 2, (VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(APBlocks.PIPE.get().asItem(), 4, 4, 12, 6, 0.1f));
            APTrades.addTrade(VillagerProfession.SHEPHERD, 2, (VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(APBlocks.SPOOL.get().asItem(), 4, 1, 2, 5, 0.0f));
            APTrades.addTrade(VillagerProfession.MASON, 1, (VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(APBlocks.MYONITE.get(), 3, 1, 16, 5));
            APTrades.addTrade(VillagerProfession.MASON, 1, (VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(APBlocks.OLIVESTONE_BRICK.get(), 3, 1, 16, 5));
        }
        if (((Boolean)APConfig.WANDERER_TRADES_ENABLED.get()).booleanValue()) {
            APTrades.addWondering((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(APBlocks.SUNSTONE.get(), 2, 6, 20, 2));
            APTrades.addWondering((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(APBlocks.MOONSTONE.get(), 2, 6, 20, 2));
        }
    }
}

