/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.events;

import architectspalette.core.registry.APSounds;
import architectspalette.core.registry.APTags;
import architectspalette.core.registry.ParticleRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ProjectileImpactEvent {
    public static boolean projectileImpact(Projectile projectile, HitResult ray) {
        BlockHitResult hitResult;
        return projectile.getDeltaMovement().length() > 0.2 && ray instanceof BlockHitResult && ProjectileImpactEvent.deflect(projectile, hitResult = (BlockHitResult)ray, 0);
    }

    public static boolean deflect(Projectile projectile, BlockHitResult hitResult, int depth) {
        BlockState state = projectile.level().getBlockState(hitResult.getBlockPos());
        Level level = projectile.level();
        if (state.is(APTags.WIZARD_BLOCKS)) {
            BlockHitResult check;
            Vec3 a;
            Vec3 stairsVector;
            Vec3 normal = Vec3.atLowerCornerOf((Vec3i)hitResult.getDirection().getNormal());
            if (state.getBlock() instanceof StairBlock && (stairsVector = ProjectileImpactEvent.doStairsMath(hitResult.getDirection(), state)) != null) {
                normal = normal.add(stairsVector).normalize();
            }
            Vec3 motion = projectile.getDeltaMovement();
            double previousSpeed = motion.length();
            double dot = motion.dot(normal);
            if (-dot > 0.05) {
                dot += 0.05;
            }
            if ((a = normal.scale(-dot * 2.0)).length() < 0.05 && hitResult.getDirection() == Direction.UP) {
                return false;
            }
            projectile.setDeltaMovement(motion.add(a));
            Vec3 newMotion = projectile.getDeltaMovement();
            double d0 = newMotion.horizontalDistance();
            float xrot = (float)(Mth.atan2((double)newMotion.y, (double)d0) * 57.29577951308232);
            float yrot = (float)(Mth.atan2((double)newMotion.x, (double)newMotion.z) * 57.29577951308232);
            Vec3 moveTo = projectile.position();
            projectile.absMoveTo(moveTo.x, moveTo.y, moveTo.z, yrot, xrot);
            Vec3 hit = hitResult.getLocation().add(normal.scale(0.02));
            if (level.isClientSide) {
                level.addParticle((ParticleOptions)ParticleRegistry.WIZARDLY_DEFENSE_BLAST.get(), hit.x, hit.y, hit.z, normal.x, normal.y, normal.z);
                level.playLocalSound(hit.x, hit.y, hit.z, APSounds.WIZARD_BLAST.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.4f + 0.8f, false);
            }
            if ((check = level.clip(new ClipContext(projectile.position(), projectile.position().add(newMotion), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)projectile))).getType() != HitResult.Type.MISS && !check.isInside() && check.getBlockPos() != hitResult.getBlockPos()) {
                projectile.setPos(check.getLocation().subtract(newMotion.scale(1.1)));
            }
            return true;
        }
        return false;
    }

    private static Vec3 doStairsMath(Direction direction, BlockState state) {
        Half half = (Half)state.getValue((Property)StairBlock.HALF);
        Vec3 e = null;
        if (direction == ((Direction)state.getValue((Property)StairBlock.FACING)).getOpposite()) {
            Vec3 vec3 = e = half == Half.BOTTOM ? new Vec3(0.0, 1.0, 0.0) : new Vec3(0.0, -1.0, 0.0);
        }
        if (direction == Direction.UP && half == Half.BOTTOM || direction == Direction.DOWN && half == Half.TOP) {
            e = Vec3.atLowerCornerOf((Vec3i)((Direction)state.getValue((Property)StairBlock.FACING)).getOpposite().getNormal());
        }
        return e;
    }
}

