/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.event;

import architectspalette.core.config.APConfig;
import architectspalette.core.integration.APTrades;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

public class TradingEventHandler {
    @SubscribeEvent
    public static void onTradesLoaded(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        Map<Integer, LinkedList<VillagerTrades.ItemListing>> tradeMap = APTrades.PROFESSION_MAP.get(profession);
        if (tradeMap == null) {
            return;
        }
        Int2ObjectMap trades = event.getTrades();
        trades.forEach((level, list) -> {
            if (tradeMap.containsKey(level)) {
                list.addAll((Collection)tradeMap.get(level));
            }
        });
    }

    @SubscribeEvent
    public static void onWanderingTradesLoaded(WandererTradesEvent event) {
        if (!((Boolean)APConfig.WANDERER_TRADES_ENABLED.get()).booleanValue()) {
            return;
        }
        List generic = event.getGenericTrades();
        APTrades.WONDERING_TRADES.forEach((level, trades) -> generic.addAll(trades));
    }
}

