/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.event;

import architectspalette.core.APConstants;
import architectspalette.core.model.BoardModel;
import architectspalette.core.model.util.SpriteShift;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class RegisterModelLoadersEventHandler {
    @SubscribeEvent
    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(APConstants.WRAPPER_LOADER, (IGeometryLoader)new WrappedModelLoader());
    }

    static {
        WrappedModelLoader.register("boards", (context, bakedModel, blockModel) -> {
            ResourceLocation texture = blockModel.getMaterial("particle").texture();
            return new BoardModel(bakedModel, SpriteShift.getShift(texture, texture.withSuffix("_odd")));
        });
    }

    private static class WrappedModelLoader
    implements IGeometryLoader<WrappedUnbakedModel> {
        private static final Map<String, ModelWrapper> wrappers = new HashMap<String, ModelWrapper>();

        private WrappedModelLoader() {
        }

        private static void register(String name, ModelWrapper wrappingFunction) {
            wrappers.put(name, wrappingFunction);
        }

        public WrappedUnbakedModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            JsonObject wrappedModel = jsonObject.get("wrapped_model").getAsJsonObject();
            String wrapperType = jsonObject.get("wrapper_type").getAsString();
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)wrappedModel, BlockModel.class);
            return new WrappedUnbakedModel(baseModel, wrappers.get(wrapperType));
        }
    }

    @FunctionalInterface
    private static interface ModelWrapper {
        public BakedModelWrapper<?> apply(IGeometryBakingContext var1, BakedModel var2, BlockModel var3);
    }

    private static class WrappedUnbakedModel
    implements IUnbakedGeometry<WrappedUnbakedModel> {
        private final BlockModel wrappedModel;
        private final ModelWrapper wrapper;

        public WrappedUnbakedModel(BlockModel modelToWrap, ModelWrapper func) {
            this.wrappedModel = modelToWrap;
            this.wrapper = func;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
            BakedModel baked = this.wrappedModel.bake(bakery, this.wrappedModel, spriteGetter, modelState, context.useBlockLight());
            return this.wrapper.apply(context, baked, this.wrappedModel);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.wrappedModel.resolveParents(modelGetter);
        }
    }
}

