/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.event;

import architectspalette.core.model.BoardModel;
import architectspalette.core.model.SheetMetalModel;
import architectspalette.core.model.util.SpriteShift;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.util.BlockNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModelBakeEventHandler {
    private static final Map<Entry, Function<BakedModel, ? extends BakedModel>> customBlockModels = new HashMap<Entry, Function<BakedModel, ? extends BakedModel>>();

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        ModelBakeEventHandler.register((DeferredHolder<Block, ? extends Block>)((DeferredHolder)APBlocks.SHEET_METAL.getObject()), model -> new SheetMetalModel((BakedModel)model, SpriteShift.getShift("block/sheet_metal_block", "block/sheet_metal_block_ct")));
        ModelBakeEventHandler.register((DeferredHolder<Block, ? extends Block>)((DeferredHolder)APBlocks.SHEET_METAL.getChild(BlockNode.BlockType.WALL)), model -> new SheetMetalModel((BakedModel)model, SpriteShift.getShift("block/sheet_metal_block", "block/sheet_metal_block_ct")));
        customBlockModels.forEach((entry, factory) -> ModelBakeEventHandler.swapModels(modelRegistry, ModelBakeEventHandler.getAllBlockStateModelLocations(entry), factory));
    }

    @Deprecated
    public static void registerBoardModel(Supplier<Block> supplier, ResourceLocation blockToRegister, ResourceLocation baseBoardBlock) {
        ResourceLocation inBlockFolder = baseBoardBlock.withPrefix("block/");
        ResourceLocation odd = inBlockFolder.withSuffix("_odd");
        ModelBakeEventHandler.register(supplier, blockToRegister, model -> new BoardModel((BakedModel)model, SpriteShift.getShift(inBlockFolder, odd)));
    }

    private static <T extends BakedModel> void swapModels(Map<ModelResourceLocation, BakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<BakedModel, T> modelFactory) {
        locations.forEach(location -> modelRegistry.put((ModelResourceLocation)location, (BakedModel)modelFactory.apply((BakedModel)modelRegistry.get(location))));
    }

    private static List<ModelResourceLocation> getAllBlockStateModelLocations(Entry entry) {
        return ModelBakeEventHandler.getAllBlockStateModelLocations(entry.getBlock(), entry.getResourceLocation());
    }

    private static List<ModelResourceLocation> getAllBlockStateModelLocations(Block block, ResourceLocation resourceLocation) {
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
        block.getStateDefinition().getPossibleStates().forEach(state -> models.add(BlockModelShaper.stateToModelLocation((ResourceLocation)resourceLocation, (BlockState)state)));
        return models;
    }

    public static <T extends BakedModel> void register(DeferredHolder<Block, ? extends Block> registryObject, Function<BakedModel, T> modelFactory) {
        ModelBakeEventHandler.register(registryObject, registryObject.getId(), modelFactory);
    }

    public static <T extends BakedModel> void register(Supplier<? extends Block> blockSupplier, ResourceLocation resourceLocation, Function<BakedModel, T> modelFactory) {
        customBlockModels.put(new Entry(resourceLocation, blockSupplier), modelFactory);
    }

    private static class Entry {
        private final ResourceLocation resourceLocation;
        private final Supplier<? extends Block> block;

        public Entry(ResourceLocation resourceLocation, Supplier<? extends Block> block) {
            this.resourceLocation = resourceLocation;
            this.block = block;
        }

        public Block getBlock() {
            return this.block.get();
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }
    }
}

