/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.crafting;

import architectspalette.core.registry.APRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WarpingRecipe
implements Recipe<SingleRecipeInput> {
    private final Ingredient input;
    private final ItemStack output;
    private final ResourceLocation dimension;

    public WarpingRecipe(Ingredient input, ItemStack output, ResourceLocation dimension) {
        this.input = input;
        this.output = output;
        this.dimension = dimension;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(SingleRecipeInput input, @NotNull Level level) {
        return this.input.test(input.getItem(0)) && this.dimension.compareTo(level.dimension().location()) == 0;
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.getResultItem(provider).copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output;
    }

    public ItemStack getResult() {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)this.input, (Object[])new Ingredient[0]);
    }

    @NotNull
    public RecipeType<?> getType() {
        return APRecipes.WARPING.get();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return APRecipes.WARPING_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<WarpingRecipe> {
        public static final MapCodec<WarpingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)ResourceLocation.CODEC.fieldOf("dimension").forGetter(recipe -> recipe.dimension)).apply((Applicative)instance, WarpingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WarpingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.input, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.output, (StreamCodec)ResourceLocation.STREAM_CODEC, recipe -> recipe.dimension, WarpingRecipe::new);

        @NotNull
        public MapCodec<WarpingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, WarpingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

