/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core;

import architectspalette.core.APCommon;
import architectspalette.core.config.APConfig;
import architectspalette.core.event.BlockToolModificationEventHandler;
import architectspalette.core.event.CreativeModeTabEventHandler;
import architectspalette.core.event.ModelBakeEventHandler;
import architectspalette.core.event.RegisterModelLoadersEventHandler;
import architectspalette.core.event.RegisterParticleProvidersEventHandler;
import architectspalette.core.event.TextureStitchEventHandler;
import architectspalette.core.event.TradingEventHandler;
import architectspalette.core.integration.APVerticalSlabsCondition;
import architectspalette.core.loot.WitheredBoneLootModifier;
import architectspalette.core.platform.NeoRegistryHelper;
import architectspalette.core.registry.APBiomeModifiers;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="architects_palette")
public class ArchitectsPalette {
    public ArchitectsPalette(IEventBus modBus, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)APConfig.COMMON_CONFIG);
        APCommon.init();
        NeoRegistryHelper.register(modBus);
        modBus.addListener(EventPriority.LOWEST, this::setupCommon);
        modBus.addListener(EventPriority.LOWEST, this::setupClient);
        modBus.addListener(CreativeModeTabEventHandler::onCreativeTabRegister);
        NeoForge.EVENT_BUS.addListener(TradingEventHandler::onTradesLoaded);
        NeoForge.EVENT_BUS.addListener(TradingEventHandler::onWanderingTradesLoaded);
        WitheredBoneLootModifier.register(modBus);
        APVerticalSlabsCondition.registerCondition(modBus);
        NeoForge.EVENT_BUS.addListener(BlockToolModificationEventHandler::addCustomStripping);
        if (FMLEnvironment.dist.isClient()) {
            modBus.addListener(RegisterParticleProvidersEventHandler::registerParticleFactories);
            modBus.addListener(TextureStitchEventHandler::onTextureStitchPost);
            modBus.addListener(RegisterModelLoadersEventHandler::registerModelLoaders);
            modBus.addListener(ModelBakeEventHandler::onModelBake);
        }
        APBiomeModifiers.BIOME_MODIFIER_SERIALIZER.register(modBus);
    }

    void setupCommon(FMLCommonSetupEvent event) {
        APCommon.lateInit();
    }

    void setupClient(FMLClientSetupEvent event) {
        APCommon.initClient();
    }
}

